!/**
 * Highstock JS v11.4.8 (2024-08-29)
 *
 * Indicator series type for Highcharts Stock
 *
 * (c) 2010-2024 Kamil Kulig
 *
 * License: www.highcharts.com/license
 */function(e){"object"==typeof module&&module.exports?(e.default=e,module.exports=e):"function"==typeof define&&define.amd?define("highcharts/indicators/regressions",["highcharts","highcharts/modules/stock"],function(t){return e(t),e.Highcharts=t,e}):e("undefined"!=typeof Highcharts?Highcharts:void 0)}(function(e){"use strict";var t=e?e._modules:{};function s(t,s,n,r){t.hasOwnProperty(s)||(t[s]=r.apply(null,n),"function"==typeof CustomEvent&&e.win.dispatchEvent(new CustomEvent("HighchartsModuleLoaded",{detail:{path:s,module:t[s]}})))}s(t,"Stock/Indicators/LinearRegression/LinearRegressionIndicator.js",[t["Core/Series/SeriesRegistry.js"],t["Core/Utilities.js"]],function(e,t){let{sma:s}=e.seriesTypes,{isArray:n,extend:r,merge:i}=t;class o extends s{getRegressionLineParameters(e,t){let s=this.options.params.index,r=function(e,t){return n(e)?e[t]:e},i=e.reduce(function(e,t){return t+e},0),o=t.reduce(function(e,t){return r(t,s)+e},0),a=i/e.length,l=o/t.length,p,c,u=0,g=0;for(c=0;c<e.length;c++)u+=(p=e[c]-a)*(r(t[c],s)-l),g+=Math.pow(p,2);let d=g?u/g:0;return{slope:d,intercept:l-d*a}}getEndPointY(e,t){return e.slope*t+e.intercept}transformXData(e,t){let s=e[0];return e.map(function(e){return(e-s)/t})}findClosestDistance(e){let t,s,n;for(n=1;n<e.length-1;n++)(t=e[n]-e[n-1])>0&&(void 0===s||t<s)&&(s=t);return s}getValues(e,t){let s,n,r,i,o,a,l,p,c;let u=e.xData,g=e.yData,d=t.period,f={xData:[],yData:[],values:[]},h=this.options.params.xAxisUnit||this.findClosestDistance(u);for(n=d-1;n<=u.length-1;n++)r=n-d+1,i=n+1,o=u[n],l=u.slice(r,i),p=g.slice(r,i),c=this.transformXData(l,h),s=this.getRegressionLineParameters(c,p),a=this.getEndPointY(s,c[c.length-1]),f.values.push({regressionLineParameters:s,x:o,y:a}),f.xData.push(o),f.yData.push(a);return f}}return o.defaultOptions=i(s.defaultOptions,{params:{xAxisUnit:null},tooltip:{valueDecimals:4}}),r(o.prototype,{nameBase:"Linear Regression Indicator"}),e.registerSeriesType("linearRegression",o),o}),s(t,"Stock/Indicators/LinearRegressionSlopes/LinearRegressionSlopesIndicator.js",[t["Core/Series/SeriesRegistry.js"],t["Core/Utilities.js"]],function(e,t){let{linearRegression:s}=e.seriesTypes,{extend:n,merge:r}=t;class i extends s{getEndPointY(e){return e.slope}}return i.defaultOptions=r(s.defaultOptions),n(i.prototype,{nameBase:"Linear Regression Slope Indicator"}),e.registerSeriesType("linearRegressionSlope",i),i}),s(t,"Stock/Indicators/LinearRegressionIntercept/LinearRegressionInterceptIndicator.js",[t["Core/Series/SeriesRegistry.js"],t["Core/Utilities.js"]],function(e,t){let{linearRegression:s}=e.seriesTypes,{extend:n,merge:r}=t;class i extends s{getEndPointY(e){return e.intercept}}return i.defaultOptions=r(s.defaultOptions),n(i.prototype,{nameBase:"Linear Regression Intercept Indicator"}),e.registerSeriesType("linearRegressionIntercept",i),i}),s(t,"Stock/Indicators/LinearRegressionAngle/LinearRegressionAngleIndicator.js",[t["Core/Series/SeriesRegistry.js"],t["Core/Utilities.js"]],function(e,t){let{linearRegression:s}=e.seriesTypes,{extend:n,merge:r}=t;class i extends s{slopeToAngle(e){return 180/Math.PI*Math.atan(e)}getEndPointY(e){return this.slopeToAngle(e.slope)}}return i.defaultOptions=r(s.defaultOptions,{tooltip:{pointFormat:'<span style="color:{point.color}">●</span>{series.name}: <b>{point.y}\xb0</b><br/>'}}),n(i.prototype,{nameBase:"Linear Regression Angle Indicator"}),e.registerSeriesType("linearRegressionAngle",i),i}),s(t,"masters/indicators/regressions.src.js",[t["Core/Globals.js"]],function(e){return e})});