<?php

class AlertSQL {
    function __construct()
    {
        $this->ci = & get_instance();
        $this->ci->load->model(array('advancedreports_model', 'host_model'));
    }

    function calculatePercentage($fail, $total) {

        $fail = (int)$fail;

        $total = (int)$total;

        if ($total === 0 && $fail === 0)
        {
            return 0;
        }

        if ($total === 0 && $fail !== 0) {
            return 100;
        }
        // round to 10 sign
        return round( ( ($fail/$total) * 100), 0);
    }


    function utils_getIncludesFromAlert($alert)
    {

        if (empty($alert->hostContexts) || !isset($alert->hostContexts['includes']))
        {
            $includes = array();
        }
        else
        {
            $includes = $alert->hostContexts['includes'];
        }

        return $includes;
    }

    function utils_getExcludesFromAlert($alert)
    {

        if (empty($alert->excludedHosts) || !isset($alert->excludedHosts['excludes']))
        {
            $excludes = array();
        }
        else
        {
            $excludes = $alert->excludedHosts['excludes'];
        }

        return $excludes;
    }
}
