<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

////////////////////////////////////////////////////////////////////////////////
//
//  User defined constants
//
//
$secrets = parse_ini_file(SECRETS_INI_PATH);

// Path to save CSV and PDF files from reports on hosts page
$config['tmp_dir'] = FCPATH . 'static/';


// Path to save CSV and PDF files from scheduled reports relative to webroot
$config['scheduled_reports_save_path'] = FCPATH . 'static/';

// Default FROM email address
$config['appemail'] = 'admin@organisation.com';

// Default folder to upload notification scripts
$config['notification_script_dir'] = '/opt/cfengine/notification_scripts';

// Default user to run notification script as
$config['notification_script_user'] = 'cfapache';



// Default TITLE for scheduled reports
$config['advanced_report_title'] = 'Custom report';


// Max allowed time for PDF generation in seconds
$config['pdf_generation_timeout'] = 7200; // 2hrs

/**
* Eg::
* array(
*  	CURLOPT_SSL_VERIFYPEER => false, // stop cURL from verifying the peer's certificate
* 	CURLOPT_FOLLOWLOCATION => false,  // follow redirects, Location: headers
* 	CURLOPT_MAXREDIRS      => 10     // but dont redirect more than 10 times
*  );
*/
$config['PEST_CURL_OPTS'] = array();

$config['MP_CLIENT_ID'] = 'MP';
$config['MP_CLIENT_SECRET'] = $secrets['mp_client_secret'];
$config['MP_GRANT_TYPE'] = 'password';


$config['LDAP_API_SERVER_SECRET'] = $secrets['ldap_api_secret'];

$protocol = key_exists('HTTPS', $_SERVER) ? 'https://' : 'http://';
// Use the same port as Mission Portal in the API url
// if ports are default HTTP or HTTPS then skip
$port = key_exists('SERVER_PORT', $_SERVER) && !in_array($_SERVER['SERVER_PORT'], [443, 80]) ? ':' . $_SERVER['SERVER_PORT'] : '';
$serverName = ($_SERVER['SERVER_NAME'] ?? '127.0.0.1');

// URL for Enterprise REST API server
if (CLI === false)
{
    // We need a fully qualifed host name (FQDN), not just a hostname, therefore
    // this long chain of gethost* functions.

    // Use the same server name to call the API.
    // This is needed to send emails from the API with
    // the correct domain name, otherwise they will point to 127.0.0.1
    $config['rest_server'] = $protocol . $serverName . $port . '/api/';
}

$config['ldapApiUrl'] =  $protocol . $serverName . $port . '/ldap/';
// --------------- DO NOT CHANGE ANYTHING BELOW THIS LINE  ---------------------


$config['image_dir']    = 'images/';
$config['css_dir']      = 'css/';
$config['scripts_dir']  = 'scripts/';
$config['hub_dir']      = '/hub/';
$config['graph_dir']    = './graphs/';
$config['policies_dir'] = './policies/';

$config['constellation'] = 'themes/constellation/';
$config['default']       = 'themes/default/';

$config['company_logo_path']      = FCPATH . 'public/tmp/';
$config['company_logo_url_path']  = 'tmp/';
$config['company_logo_file_name'] = 'pdf_logo.jpg';



// set default mode for promisesfilter, used inside models
$config['default_promisesfilter_mode'] = 'all';

//  see advancedreports/index, set CURRENT_DATETIME value to have generated time as default description
$config['advanced_report_description_type'] = '';


$config['CFE_ROBOT_EMAIL'] = $config['appemail'];
$config['CFE_ROBOT_ROLES'] = array("cf_remoteagent");


$config['CFE_TRUNCATE_EVENTS'] = 604800; // 1 week in seconds

$config['RESET_PASSWORD_EXPIRE_AFTER_HOURS'] = 48;
