<?php
class Dashboard extends Cf_Controller
{

    function __construct()
    {
        parent::__construct();
        setCurrentApplication('dashboard');
    }

    function index()
    {

        $requiredjs = array(
            array('dist/angular-base.bundle.js'),

            array('dashboard/dca.js'),

            array('dashboard/app.js'),

            array('dashboard/controllers/dashboardController.js'),
            array('dashboard/controllers/alertsController.js'),
            array('dashboard/controllers/eventsController.js'),

            array('dashboard/directives/directives.js'),
            array('dashboard/directives/widgets.js'),
            array('dashboard/directives/hostCountWidget.js'),
            array('dashboard/directives/decommissionedHostsWidget.js'),
            array('dashboard/directives/fileChangesWidget.js'),
            array('dashboard/directives/notKeptWidget.js'),
            array('dashboard/directives/inventoryWidget.js'),
            array('dashboard/directives/complianceWidget.js'),
            array('advancedreports/helpers/complianceHelpers.js'),
            array('common_directives/high-chart.js'),
            array('common_directives/health-issue.js'),
            array('common_directives/editableField.js'),

            array('dashboard/services/autocompleteService.js'),
            array('dashboard/services/alertsService.js'),
            array('dashboard/services/rulesService.js'),
            array('dashboard/services/widgetwizardService.js'),
            array('dashboard/services/dashboardService.js'),
            array('dashboard/services/changesService.js'),
            array('dashboard/services/hostCountService.js'),
            array('dashboard/services/decommissionedHostsService.js'),
            array('dashboard/services/fileChangesService.js'),
            array('dashboard/services/notKeptWidgetService.js'),
            array('dashboard/services/notificationService.js'),
            array('dashboard/services/eventsLogService.js'),
            array('dashboard/services/modalWindowService.js'),
            array('dashboard/services/widgetService.js'),
            array('dashboard/services/welcomeWizardService.js'),
            array('dashboard/services/userService.js'),
            array('advancedreports/services/reportService.js'),

            // inventory widgets
            array('dashboard/helpers/inventory/BaseInventoryWidgetClass.js'),
            array('dashboard/helpers/inventory/BarInventoryWidgetClass.js'),
            array('dashboard/helpers/inventory/PieInventoryWidgetClass.js'),
            array('dashboard/helpers/inventory/GaugeInventoryWidgetClass.js'),
            array('dashboard/helpers/inventory/TableInventoryWidgetClass.js'),

            array('dashboard/helpers/widgetHelper.js'),
            array('dashboard/helpers/tourGuideHelper.js'),
            array('dashboard/helpers/changesWidgetHelper.js'),
            array('dashboard/helpers/hostCountWidgetHelper.js'),
            array('dashboard/helpers/decommissionedHostsWidgetHelper.js'),
            array('dashboard/helpers/notKeptWidgetHelper.js'),
            array('dashboard/helpers/inventoryWidgetHelper.js'),
            array('dashboard/helpers/dashboardHelper.js'),
            array('dashboard/helpers/commonHelper.js'),
            array('dashboard/helpers/fileChangesWidgetHelper.js'),
            array('dashboard/helpers/complianceWidgetHelper.js'),

            array('dashboard/filters/dashFilters.js'),

            // environment selector
            array('common_directives/environment/services/environmentService.js'),
            array('common_directives/environment/services/naviTreeService.js'),
            array('common_directives/environment/directives/environment_directive.js'),
            array('common_directives/environment/directives/environmentSelectionDirective.js'),

            // environment selector
            array('common_directives/environment/services/environmentService.js'),
            array('common_directives/environment/services/naviTreeService.js'),
            array('common_directives/environment/directives/environment_directive.js'),
            array('common_directives/environment/directives/environmentSelectionDirective.js'),

            // hosts include exclude selector
            array('common_directives/hostsInclude/services/paginationService.js'),
            array('common_directives/hostsInclude/services/includeExcludeService.js'),
            array('common_directives/hostsInclude/services/autocompleteService.js'),
            array('common_directives/hostsInclude/services/naviTreeService.js'),
            array('common_directives/hostsInclude/directives/include_exclude_directive.js'),
            array('common_directives/hostsInclude/directives/includeExcludeSelectionDirective.js'),

            // additional fields for inventory. Application specific!
            array('dashboard/invenory_data_addons.js'),

            // inventory filter for inventory alerts
            array('common_directives/inventory/inventory_dca.js'),
            array('common_directives/inventory/services/inventoryService.js'),
            array('common_directives/inventory/services/inventoryDataService.js'),
            array('common_directives/inventory/services/inventoryFilterService.js'),
            array('common_directives/inventory/helpers/inventoryHelper.js'),
            array('common_directives/inventory/directives/inventoryFilterDirectiveCtrl.js'),
            array('common_directives/inventory/directives/inventoryFilter_directive.js'),
            array('common_directives/objectsFilter.js'),

            ['groups/services/personalGroupsService.js'],
            ['groups/services/sharedGroupsService.js'],
            ['advancedreports/dca.js'],
        );


        $highchartsjs = array(
            array('dist/highcharts.bundle.js')
        );

        $this->carabiner->js($requiredjs, $requiredjs, TRUE, FALSE, 'footer');
        $this->carabiner->js($highchartsjs, $highchartsjs, TRUE, FALSE, 'footer');

        $data = array(
            'title' => $this->lang->line('mission_portal_title') . " - " . 'Dashboard'
        );


        $data['isAdmin'] = false;

        $user_role = $this->session->userdata('roles');
        if (empty($user_role))
        {
            $user_role = array();
        }
        if (in_array('admin',$user_role) === true)
        {
            $data['isAdmin'] = true;
        }

        $this->template->load('template', 'dashboard/index', $data);
    }


    /**
     * Load partials
     *
     * @param type $partial - name of the view
     */
    function partials($partial)
    {
        $view = 'partials/' . $partial . '.php';
        $this->load->view($view);
    }

  }
