/*jslint node: true */
/*jslint browser: true*/
/*jslint nomen: true*/
/*global Class, MP_SITE_URL, angular*/
'use strict';

/*
 * Service for policy
 *
 **/


var PolicyServiceClass = Class.extend({
    POLICY_URL: MP_SITE_URL + '/policy/policyAPI',
    /**
     * @param data
     * @returns {*}
     */
    getPolicyStatistic: function (data) {
        var url = this.POLICY_URL + '/policyStatistic';
        return this.$http({
            method: 'GET',
            headers: {
                'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'
            },
            url: url,
            params: {
                "promiseOutcome[]": data.promiseOutcome,
                "hostIncludes[]": data.includes,
                "hostExcludes[]" : data.excludes,
                inventoryFilter: data.inventory
            },
            cache: false
        });
    },

    enableCopying: function () {
        var url = this.POLICY_URL + '/enableCopying';
        return this.$http({
            method: 'GET',
            headers: {
                'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'
            },
            url: url,
            cache: false
        });
    },
    enablingStatus: function () {
        var url = this.POLICY_URL + '/enablingStatus';
        return this.$http({
            method: 'GET',
            headers: {
                'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'
            },
            url: url,
            cache: false
        });
    },
    getPolicyFile: function (filename) {
        var url = this.POLICY_URL + '/getFile';
        return this.$http({
            method: 'POST',
            headers: {
                'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'
            },
            url: url,
            data: $.param({fileName: filename}),
            cache: true
        });
    },

    getPolicyFiles: function () {
        var url = this.POLICY_URL + '/files';
        return this.$http({
            method: 'GET',
            headers: {
                'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'
            },
            url: url,
            cache: true
        });
    },

    getPolicyInfoByFilePath: function (data) {
        var url = this.POLICY_URL + '/getPolicyInfoByFilePath';
        return this.$http({
            method: 'POST',
            headers: {
                'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'
            },
            url: url,
            data: $.param(data),
            cache: true
        });
    },

});

(function () {
    var policyServiceProvider = Class.extend({
        instance: new PolicyServiceClass(),
        $get: ['$http', function ($http) {
            this.instance.$http = $http;
            return this.instance;
        }]
    });

    angular.module('policyServiceModule', [])
        .provider('policyService', policyServiceProvider);
}());