#!/usr/bin/env bash
# TODO, would be better to use docker ps --filter "name=$name" | wc -l and check for non-zero
# but a simple grep is easier and should work in most cases.
set -ex
name=openldap
if docker ps | grep $name; then
  docker stop $name
fi
if docker ps -a | grep $name; then
  docker rm $name
fi
if docker images | grep $name; then
  docker rmi $name
fi
docker build --no-cache -t $name -f ./Dockerfile .
docker run -d -p 389:389 -p 636:636 --name $name $name
