<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

/**
 * Carabiner 1.45 configuration file.
 * CodeIgniter-library for Asset Management
 */
/*
  |--------------------------------------------------------------------------
  | Script Directory
  |--------------------------------------------------------------------------
  |
  | Path to the script directory.  Relative to the CI front controller.
  |
 */

$config['script_dir'] = 'public/scripts/';
$config['script_url'] = 'scripts/';


/*
  |--------------------------------------------------------------------------
  | Style Directory
  |--------------------------------------------------------------------------
  |
  | Path to the style directory.  Relative to the CI front controller
  |
 */
if (is_constellation())
{
    $config['style_dir'] = 'public/themes/constellation/css/';
}
else
{
    $config['style_dir'] = 'public/scripts/';
}

$config['style_url'] = 'scripts/';

/*
  |--------------------------------------------------------------------------
  | Cache Directory
  |--------------------------------------------------------------------------
  |
  | Path to the cache directory. Must be writable. Relative to the CI
  | front controller.
  |
 */

$config['cache_dir'] = 'public/tmp/';
$config['cache_url_dir'] = 'tmp/';
$config['cache_permissions'] = 0440;




/*
 * The following config values are not required.  See Libraries/Carabiner.php
 * for more information.
 */



/*
  |--------------------------------------------------------------------------
  | Base URI
  |--------------------------------------------------------------------------
  |
  |  Base uri of the site, like http://www.example.com/ Defaults to the CI
  |  config value for base_url.
  |
 */

//$config['base_uri'] = 'http://www.example.com/';


/*
  |--------------------------------------------------------------------------
  | Development Flag
  |--------------------------------------------------------------------------
  |
  |  Flags whether your in a development environment or not. Defaults to FALSE.
  |
 */

$config['dev'] = (ENVIRONMENT == 'development') ? true : false; // set in index.php


/*
  |--------------------------------------------------------------------------
  | Combine
  |--------------------------------------------------------------------------
  |
  | Flags whether files should be combined. Defaults to TRUE.
  |
 */

$config['combine'] = true;


/*
  |--------------------------------------------------------------------------
  | Minify Javascript
  |--------------------------------------------------------------------------
  |
  | Global flag for whether JS should be minified. Defaults to TRUE.
  |
 */

$config['minify_js'] = false;


/*
  |--------------------------------------------------------------------------
  | Minify CSS
  |--------------------------------------------------------------------------
  |
  | Global flag for whether CSS should be minified. Defaults to TRUE.
  |
 */

$config['minify_css'] = false;

/*
  |--------------------------------------------------------------------------
  | Force cURL
  |--------------------------------------------------------------------------
  |
  | Global flag for whether to force the use of cURL instead of file_get_contents()
  | Defaults to FALSE.
  |
 */

$config['force_curl'] = FALSE;


/*
  |--------------------------------------------------------------------------
  | Predifined Asset Groups
  |--------------------------------------------------------------------------
  |
  | Any groups defined here will automatically be included.  Of course, they
  | won't be displayed unless you explicity display them ( like this: $this->carabiner->display('jquery') )
  | See docs for more.
  |
  | Currently created groups:
  |	> jQuery (latest in 1.xx version)
  |	> jQuery UI (latest in 1.xx version)
  |	> Ext Core (latest in 3.xx version)
  |	> Chrome Frame (latest in 1.xx version)
  |	> Prototype (latest in 1.x.x.x version)
  |	> script.aculo.us (latest in 1.x.x version)
  |	> Mootools (1.xx version)
  |	> Dojo (latest in 1.xx version)
  |	> SWFObject (latest in 2.xx version)
  |	> YUI (latest core JS/CSS in 2.x.x version)
  |
 */

// CFEngine base
$config['groups']['CFEngine'] = array(
    'css' => array(
        array('dist/cfengine.css', 'screen')
    ),
    'js' => array(
        array('dist/vendor.bundle.js'),
        array('dist/cfengine.bundle.js'),
    )
);

$config['groups']['footer'] = array(
    'js' => array(
        array('dist/footer.bundle.js', 'dist/footer.bundle.js', FALSE, TRUE),
        array('dist/globalHostSearch.bundle.js', 'dist/globalHostSearch.bundle.js', FALSE, FALSE),
        array('dist/auditLogEntryPoint.bundle.js', 'dist/auditLogEntryPoint.bundle.js', FALSE, FALSE),
        array('dist/aiAgent.bundle.js', 'dist/aiAgent.bundle.js', FALSE, FALSE),
        array('dist/cmdb.bundle.js', 'dist/cmdb.bundle.js', FALSE, FALSE),
    )
);

