<?php


class SettingsScriptsImporter extends BaseDataImporter
{
    public function isOnlyForAdmin(): bool
    {
        return true;
    }

    public function import($data)
    {
        $this->saveScripts();
        $data = json_decode($data, JSON_OBJECT_AS_ARRAY);
        foreach ($data as $script) {
            $this->db->reset_query();
            $filter = ['name' => $script['name']];
            $exist = $this->db->get_where('dashboard_scripts', $filter);

            unset($script['id']);
            if ($exist->num_rows() == 0) {
                $this->db->insert('dashboard_scripts', $script);
            } elseif ($this->skipDuplicates == 0) {
                $this->db->update('dashboard_scripts', $script, $filter);
            }
        }
    }
}
