<?php

/**
 * Class Cf_DB_driver
 */
class Cf_DB_query_builder extends CI_DB_query_builder
{
    /**
     * @param $item
     * @return mixed
     */
    public function escape_identifiers($item)
    {
        return $item;
    }

    /**
     * Returns the SQL string operator
     *
     * @param	string
     * @return	string
     */
    protected function _get_operator($str)
    {
        static $_operators;

        if (empty($_operators))
        {
            $_les = ($this->_like_escape_str !== '')
                ? '\s+'.preg_quote(trim(sprintf($this->_like_escape_str, $this->_like_escape_chr)), '/')
                : '';
            $_operators = array(
                '\s*<@\s*',                       // <@
                '\s*@>\s*',                       // @>
                '\s*(?:<|>|!)?=\s*',             // =, <=, >=, !=
                '\s*<>?\s*',                     // <, <>
                '\s*>\s*',                       // >
                '\s+IS NULL',                    // IS NULL
                '\s+IS NOT NULL',                // IS NOT NULL
                '\s+EXISTS\s*\(.*\)',        // EXISTS(sql)
                '\s+NOT EXISTS\s*\(.*\)',    // NOT EXISTS(sql)
                '\s+BETWEEN\s+',                 // BETWEEN value AND value
                '\s+IN\s*\(.*\)',            // IN(list)
                '\s+NOT IN\s*\(.*\)',        // NOT IN (list)
                '\s+LIKE\s+\S.*('.$_les.')?',    // LIKE 'expr'[ ESCAPE '%s']
                '\s+NOT LIKE\s+\S.*('.$_les.')?' // NOT LIKE 'expr'[ ESCAPE '%s']
            );

        }

        return preg_match('/'.implode('|', $_operators).'/i', $str, $match)
            ? $match[0] : FALSE;
    }

    /**
     * LIMIT string
     *
     * Generates a platform-specific LIMIT clause.
     *
     * @param	string	$sql	SQL Query
     * @return	string
     */
    protected function _limit($sql)
    {
        return $sql.' OFFSET ' . (int) $this->qb_offset . ' LIMIT ' . (int) $this->qb_limit;
    }

}