<div class="settingsPage">
    <div class="left-column">
        <?php include('settingsSideBar.php'); ?></div>
    <div class="right-column">
        <div class="pageTitle">

            <h1>
                <span>Version control repository</span>
                <?php /*hide if no settings */
                if ( ! empty($hasSettings)) { ?><a href="<?php echo site_url('settings/vcsReset/'); ?>"
                                                   class="btn btn-large pull-right" id="clear-git-settings">Clear
                        settings</a><?php } ?>
            </h1>

        </div>

        <div>

            <div class="pullTop">

                <?php
                if (($this->session->flashdata('message')) || ( ! empty($message) && is_array($message))) {
                    $flashMessage  = $this->session->flashdata('message') ? $this->session->flashdata('message') : $message;
                    $content       = $flashMessage['content'];
                    $content_class = $flashMessage['type'];
                    ?>

                    <div class="alert <?= htmlspecialchars($content_class) ?>
                     ">
                        <button class="close" data-dismiss="alert"><i class="bi bi-x"></i></button>
                        <?php echo nl2br(htmlspecialchars($content)); ?>
                    </div>
                <?php } ?>
            </div>


            <?php
            $attributes = array(
                'class'   => 'form-horizontal confirm-before-leave',
                'id'      => 'VCSform',
                'method'  => 'POST',
                'enctype' => "multipart/form-data"
            );
            echo form_open('settings/vcs/', $attributes);
            ?>

            <div class="control-group required">
                <label class="control-label" for="vcsType"> <b>VCS type</b>
                </label>
                <div class="controls">
                    <?php
                    $options = ['GIT' => 'Git', 'GIT_CFBS' => 'Git repo with cfbs project'];
                    echo form_dropdown('vcsType', $options, $vcsType);
                    ?>
                </div>
            </div>
            <hr/>
            <div class="control-group required">
                <label class="control-label" for="gitServer"> <b>Git server url</b>
                </label>
                <div class="controls">
                    <textarea class="input-xlarge" id="gitServer" name="gitServer"
                              value=""><?= htmlspecialchars($gitServer) ?></textarea>
                    <p class="help-block"><?php echo tooltip('tooltip_git_url', '', true); ?></p>
                </div>
            </div>
            <hr/>
            <div class="control-group required">
                <label class="control-label" for="gitRefspec"> <b>Git refspec</b>
                </label>

                <div class="controls git-refspec-input">
                    <input class="input-xlarge" type="text" id="git_refspec" name="gitRefspec"
                           value="<?= htmlspecialchars($gitRefspec) ?>"/>
                </div>
            </div>

            <div class="control-group">
                <label class="control-label" for="projectSubdirectory"> <b>Project subdirectory</b></label>
                <div class="controls git-subdirectory-input">
                    <input 
                            class="input-xlarge"
                            type="text" id="projectSubdirectory"
                            placeholder="path/to/cfengine_policies/"
                            name="projectSubdirectory" value="<?= htmlspecialchars($projectSubdirectory ?? '') ?>"
                    />
                    <p class="help-block">Subdirectory inside GIT repository where the project is located (optional).</p>
                </div>
            </div>

            <hr/>
            <div class="control-group">
                <label class="control-label" for="gitUsername"> <b>Git username</b>
                </label>
                <div class="controls">
                    <input class="input-xlarge" type="text" id="gitUsername" name="gitUsername"
                           value="<?= htmlspecialchars($gitUsername) ?>"/>
                </div>
            </div>
            <div class="control-group">
                <label class="control-label" for="gitPassword"> <b>Git password or token</b>
                </label>
                <div class="controls">
                    <input class="input-xlarge" type="password" id="gitPassword" name="gitPassword"
                           value="<?= htmlspecialchars($gitPassword) ?>"/>
                    <?php $this->load->view('common/show-password-btn.php'); ?>
                </div>
            </div>

            <div class="control-group">
                <label class="control-label" for="gitPrivateKey">
                    <b>Git private key</b>
                </label>
                <div class="controls">
                    <input type="file" name="gitPrivateKey" id="gitPrivateKey" title="Choose file"/><span
                            class="file-input-name">No file chosen</span>
                </div>
            </div>


            <div id="btnholder" class="buttons margin-top">
                <input id="update" type="hidden" name="update" value="1"/>
                <button type="submit" id="formSubmit" value="Submit" class="btn btn-large btn-primary pull-right">
                    Apply
                </button>
            </div>

            <?php echo form_close(); ?>

        </div>
    </div>
</div>

<script type="text/javascript">


    $('#gitServer').on('input propertychange', function() {
       var url = $(this).val();
       var sshRegex = new RegExp(/[^@]+@[^:]+:[^\/]+\/[^.]+\.git/);
       var parentControlGroup = $('#gitPrivateKey').closest('.control-group');
       if(sshRegex.test(url)){
           parentControlGroup.addClass('required');
       } else {
           try{
               var credentials = url.match(/https:\/\/(.*)@/).pop();
               var parsedLoginPassword = credentials.split(':')
               var username = parsedLoginPassword[0]
               var password = parsedLoginPassword.slice(1).join(':')
               $('#gitUsername').val(username);
               $('#gitPassword').val(password);
           } catch (e){

           }
           parentControlGroup.removeClass('required');
       }

    });

    $(document).ready(function () {

        $('#clear-git-settings').click(
            function (e) {
                e.preventDefault();
                var href = $(this).attr("href");
                $("<div></div>")
                    .dialog_modal({
                        passedArgs: ["<p>Are you sure you want to clear the settings?</p>", [{

                            "label": "Cancel",
                            "class": "btn btn-large",
                            "callback": function () {

                            }
                        }, {
                            "label": "Ok",
                            "class": "btn btn-large btn-primary",
                            "callback": function () {
                                window.location.href = href;
                            }
                        }], {
                            header: "<h2>Clear settings?</h2>",
                            'onEscape': function () {
                            }
                        }],
                    })

            }
        );

        $('#VCSform').submit(
            function (e) {
                e.preventDefault();
                var currentForm = this;
                $("<div></div>")
                    .dialog_modal({
                        passedArgs: ["<div class='alert alert-warning'><p>WARNING: Changing your upstream version control repository or branch will reset all your masterfiles contents as a whole to what's in the new repository and branch.</p><p>If the 'cfengine_internal_masterfiles_update' class is defined in the currently deployed update policy this will happen automatically. To manually complete this operation run '/var/cfengine/bin/cf-agent --no-lock --define cfengine_internal_masterfiles_update --file /var/cfengine/share/NovaBase/masterfiles/update.cf'.</p><p>Are you REALLY sure you want to do this?</p></div>", [{

                            "label": "Cancel",
                            "class": "btn btn-large",
                            "callback": function () {
                            }
                        }, {
                            "label": "Confirm",
                            "class": "btn btn-large btn-primary",
                            "callback": function () {
                                common.globalSpinner.show();
                                currentForm.submit();
                            }
                        }], {
                            header: "<h2>Change settings?</h2>",
                            'onEscape': function () {
                            }
                        }],
                    })
            }
        );

        $('input[type=file]').bootstrapFileInput();
        $('.file-input-wrapper').addClass('btn-large');

    });

</script>
