!/**
 * Highstock JS v11.4.8 (2024-08-29)
 *
 * Indicator series type for Highcharts Stock
 *
 * (c) 2010-2024 Sebastian Bochan
 *
 * License: www.highcharts.com/license
 */function(o){"object"==typeof module&&module.exports?(o.default=o,module.exports=o):"function"==typeof define&&define.amd?define("highcharts/indicators/ichimoku-kinko-hyo",["highcharts","highcharts/modules/stock"],function(t){return o(t),o.Highcharts=t,o}):o("undefined"!=typeof Highcharts?Highcharts:void 0)}(function(o){"use strict";var t=o?o._modules:{};function e(t,e,n,i){t.hasOwnProperty(e)||(t[e]=i.apply(null,n),"function"==typeof CustomEvent&&o.win.dispatchEvent(new CustomEvent("HighchartsModuleLoaded",{detail:{path:e,module:t[e]}})))}e(t,"Stock/Indicators/IKH/IKHIndicator.js",[t["Extensions/DataGrouping/ApproximationRegistry.js"],t["Core/Color/Color.js"],t["Core/Series/SeriesRegistry.js"],t["Core/Utilities.js"]],function(o,t,e,n){let{parse:i}=t,{sma:s}=e.seriesTypes,{defined:p,extend:l,isArray:a,isNumber:r,getClosestDistance:h,merge:u,objectEach:c}=n;function k(o){return{high:o.reduce(function(o,t){return Math.max(o,t[1])},-1/0),low:o.reduce(function(o,t){return Math.min(o,t[2])},1/0)}}function g(o){let t=o.indicator;t.points=o.points,t.nextPoints=o.nextPoints,t.color=o.color,t.options=u(o.options.senkouSpan.styles,o.gap),t.graph=o.graph,t.fillGraph=!0,e.seriesTypes.sma.prototype.drawGraph.call(t)}class d extends s{constructor(){super(...arguments),this.data=[],this.options={},this.points=[],this.graphCollection=[]}init(){super.init.apply(this,arguments),this.options=u({tenkanLine:{styles:{lineColor:this.color}},kijunLine:{styles:{lineColor:this.color}},chikouLine:{styles:{lineColor:this.color}},senkouSpanA:{styles:{lineColor:this.color,fill:i(this.color).setOpacity(.5).get()}},senkouSpanB:{styles:{lineColor:this.color,fill:i(this.color).setOpacity(.5).get()}},senkouSpan:{styles:{fill:i(this.color).setOpacity(.2).get()}}},this.options)}toYData(o){return[o.tenkanSen,o.kijunSen,o.chikouSpan,o.senkouSpanA,o.senkouSpanB]}translate(){for(let o of(e.seriesTypes.sma.prototype.translate.apply(this),this.points))for(let t of this.pointArrayMap){let e=o[t];r(e)&&(o["plot"+t]=this.yAxis.toPixels(e,!0),o.plotY=o["plot"+t],o.tooltipPos=[o.plotX,o["plot"+t]],o.isNull=!1)}}drawGraph(){let o=this,t=o.points,n=o.options,i=o.graph,s=o.color,l={options:{gapSize:n.gapSize}},a=o.pointArrayMap.length,r=[[],[],[],[],[],[]],h={tenkanLine:r[0],kijunLine:r[1],chikouLine:r[2],senkouSpanA:r[3],senkouSpanB:r[4],senkouSpan:r[5]},k=[],d=o.options.senkouSpan,f=d.color||d.styles.fill,S=d.negativeColor,y=[[],[]],m=[[],[]],C=t.length,v=0,A,x,Y,P,B,j,G,N,X,b,T,E,L;for(o.ikhMap=h;C--;){for(Y=0,x=t[C];Y<a;Y++)p(x[A=o.pointArrayMap[Y]])&&r[Y].push({plotX:x.plotX,plotY:x["plot"+A],isNull:!1});if(S&&C!==t.length-1){let o=h.senkouSpanB.length-1,t=function(o,t,e,n){if(o&&t&&e&&n){let i=t.plotX-o.plotX,s=t.plotY-o.plotY,p=n.plotX-e.plotX,l=n.plotY-e.plotY,a=o.plotX-e.plotX,r=o.plotY-e.plotY,h=(-s*a+i*r)/(-p*s+i*l),u=(p*r-l*a)/(-p*s+i*l);if(h>=0&&h<=1&&u>=0&&u<=1)return{plotX:o.plotX+u*i,plotY:o.plotY+u*s}}}(h.senkouSpanA[o-1],h.senkouSpanA[o],h.senkouSpanB[o-1],h.senkouSpanB[o]);if(t){let e={plotX:t.plotX,plotY:t.plotY,isNull:!1,intersectPoint:!0};h.senkouSpanA.splice(o,0,e),h.senkouSpanB.splice(o,0,e),k.push(o)}}}if(c(h,(t,i)=>{n[i]&&"senkouSpan"!==i&&(o.points=r[v],o.options=u(n[i].styles,l),o.graph=o["graph"+i],o.fillGraph=!1,o.color=s,e.seriesTypes.sma.prototype.drawGraph.call(o),o["graph"+i]=o.graph),v++}),o.graphCollection)for(let t of o.graphCollection)o[t].destroy(),delete o[t];if(o.graphCollection=[],S&&h.senkouSpanA[0]&&h.senkouSpanB[0]){for(k.unshift(0),k.push(h.senkouSpanA.length-1),E=0;E<k.length-1;E++)if(P=k[E],B=k[E+1],j=h.senkouSpanB.slice(P,B+1),G=h.senkouSpanA.slice(P,B+1),Math.floor(j.length/2)>=1){let o=Math.floor(j.length/2);if(j[o].plotY===G[o].plotY){for(L=0,N=0,X=0;L<j.length;L++)N+=j[L].plotY,X+=G[L].plotY;y[T=N>X?0:1]=y[T].concat(j),m[T]=m[T].concat(G)}else y[T=j[o].plotY>G[o].plotY?0:1]=y[T].concat(j),m[T]=m[T].concat(G)}else y[T=j[0].plotY>G[0].plotY?0:1]=y[T].concat(j),m[T]=m[T].concat(G);["graphsenkouSpanColor","graphsenkouSpanNegativeColor"].forEach(function(t,e){y[e].length&&m[e].length&&(b=0===e?f:S,g({indicator:o,points:y[e],nextPoints:m[e],color:b,options:n,gap:l,graph:o[t]}),o[t]=o.graph,o.graphCollection.push(t))})}else g({indicator:o,points:h.senkouSpanB,nextPoints:h.senkouSpanA,color:f,options:n,gap:l,graph:o.graphsenkouSpan}),o.graphsenkouSpan=o.graph;delete o.nextPoints,delete o.fillGraph,o.points=t,o.options=n,o.graph=i,o.color=s}getGraphPath(o){let t=[],n,i=[];if(o=o||this.points,this.fillGraph&&this.nextPoints){if((n=e.seriesTypes.sma.prototype.getGraphPath.call(this,this.nextPoints))&&n.length){n[0][0]="L",t=e.seriesTypes.sma.prototype.getGraphPath.call(this,o),i=n.slice(0,t.length);for(let o=i.length-1;o>=0;o--)t.push(i[o])}}else t=e.seriesTypes.sma.prototype.getGraphPath.apply(this,arguments);return t}getValues(o,t){let e,n,i,s,p,l,r,u,c,g;let d=t.period,f=t.periodTenkan,S=t.periodSenkouSpanB,y=o.xData,m=o.yData,C=o.xAxis,v=m&&m.length||0,A=h(C.series.map(o=>o.xData||[])),x=[],Y=[];if(y.length<=d||!a(m[0])||4!==m[0].length)return;let P=y[0]-d*A;for(p=0;p<d;p++)Y.push(P+p*A);for(p=0;p<v;p++)p>=f&&(l=((n=k(m.slice(p-f,p))).high+n.low)/2),p>=d&&(c=(l+(r=((i=k(m.slice(p-d,p))).high+i.low)/2))/2),p>=S&&(g=((s=k(m.slice(p-S,p))).high+s.low)/2),u=m[p][3],e=y[p],void 0===x[p]&&(x[p]=[]),void 0===x[p+d-1]&&(x[p+d-1]=[]),x[p+d-1][0]=l,x[p+d-1][1]=r,x[p+d-1][2]=void 0,void 0===x[p+1]&&(x[p+1]=[]),x[p+1][2]=u,p<=d&&(x[p+d-1][3]=void 0,x[p+d-1][4]=void 0),void 0===x[p+2*d-2]&&(x[p+2*d-2]=[]),x[p+2*d-2][3]=c,x[p+2*d-2][4]=g,Y.push(e);for(p=1;p<=d;p++)Y.push(e+p*A);return{values:x,xData:Y,yData:x}}}return d.defaultOptions=u(s.defaultOptions,{params:{index:void 0,period:26,periodTenkan:9,periodSenkouSpanB:52},marker:{enabled:!1},tooltip:{pointFormat:'<span style="color:{point.color}">●</span> <b> {series.name}</b><br/>TENKAN SEN: {point.tenkanSen:.3f}<br/>KIJUN SEN: {point.kijunSen:.3f}<br/>CHIKOU SPAN: {point.chikouSpan:.3f}<br/>SENKOU SPAN A: {point.senkouSpanA:.3f}<br/>SENKOU SPAN B: {point.senkouSpanB:.3f}<br/>'},tenkanLine:{styles:{lineWidth:1,lineColor:void 0}},kijunLine:{styles:{lineWidth:1,lineColor:void 0}},chikouLine:{styles:{lineWidth:1,lineColor:void 0}},senkouSpanA:{styles:{lineWidth:1,lineColor:void 0}},senkouSpanB:{styles:{lineWidth:1,lineColor:void 0}},senkouSpan:{styles:{fill:"rgba(255, 0, 0, 0.5)"}},dataGrouping:{approximation:"ichimoku-averages"}}),l(d.prototype,{pointArrayMap:["tenkanSen","kijunSen","chikouSpan","senkouSpanA","senkouSpanB"],pointValKey:"tenkanSen",nameComponents:["periodSenkouSpanB","period","periodTenkan"]}),o["ichimoku-averages"]=function(){let t;let e=[];return[].forEach.call(arguments,function(n,i){e.push(o.average(n)),t=!t&&void 0===e[i]}),t?void 0:e},e.registerSeriesType("ikh",d),d}),e(t,"masters/indicators/ichimoku-kinko-hyo.src.js",[t["Core/Globals.js"]],function(o){return o})});