<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');


/* ---------------------------------------------------------------------
 * DECIDE if the local host is hubmaster or not for the purpose of
 * writing the logs and other things only in master hub.
 */

function initializeHub()
{
    defined('HUB_MASTER') or define('HUB_MASTER', 'localhost');
}

function is_constellation()
{
    return !defined('CONSTELLATION') ? false : constant('CONSTELLATION');
}



function get_php_bin_path()
{
    return PHP_BINDIR.'/php';
}

//this file contains the functions that generates paths to different portion of the application

function get_cssdir()
{
    $CI = &get_instance();
    if ($CI->session->userdata('theme'))
    {
        return base_url() . 'themes/' . $CI->session->userdata('theme') . '/' . $CI->config->item('css_dir');
    }
    else
    {
        return base_url() . $CI->config->item('default') . $CI->config->item('css_dir');
    }
}

function getCompiledCssdir()
{
    $CI = &get_instance();
    if ($CI->session->userdata('theme'))
    {
        return base_url() . 'themes/' . $CI->session->userdata('theme') . '/' . $CI->config->item('css_dir');
    }
    else
    {
        return base_url() . $CI->config->item('default') . 'bootstrap/compiled/css/';
    }
}

function get_scriptdir()
{
    $CI = &get_instance();
    return base_url() . $CI->config->item('scripts_dir');
}

function get_themedir()
{
 $CI = &get_instance();
    if ($CI->session->userdata('theme'))
    {
        return base_url() . 'themes/' . $CI->session->userdata('theme') ;
    }
    else
    {
        if (is_constellation())
        {
            return base_url() . $CI->config->item('constellation');
        }
        return base_url() . $CI->config->item('default') ;
    }
}


function get_imagedir()
{
    $CI = &get_instance();
    return base_url() . $CI->config->item('image_dir');
}

function get_hubdir()
{
    $CI = &get_instance();
    //return base_url().
    return $CI->config->item('hub_dir');
}

function get_graphdir()
{
    $CI = &get_instance();
    //return base_url().$CI->config->item('graph_dir');
    return $CI->config->item('graph_dir');
}

function get_policiesdir()
{
    $CI = &get_instance();
    return $CI->config->item('policies_dir');
}

function get_tmpdir()
{
    $CI = &get_instance();
    return $CI->config->item('tmp_dir');
}

/**
 * Get custom logo file
 * @param $place string
 * @return string|null
 */
function getCustomLogoFile($place = null)
{
    $CI = &get_instance();
    $CI->load->model('customization_model');
    $fileName = $CI->customization_model->getSetting('company_logo') != ''
        ? $CI->customization_model->getSetting('company_logo')
        : $CI->config->item('company_logo_file_name');

    $logoPath = $CI->config->item('company_logo_path') . $fileName;
    $logoUrl = $CI->config->item('company_logo_url_path') . $fileName;
    if ($place) {
        if ($CI->customization_model->getSetting($place) == 0) {
            return null;
        }
    }

    return file_exists(realpath($logoPath)) == true ? '/' . $logoUrl : null;
}


function getCurlConfigurationArray()
{
    $CI = & get_instance();
    $config = $CI->config->item('PEST_CURL_OPTS');
    return $config;
}
