<?php

class Build extends Cf_Controller
{

    public function __construct()
    {
        parent::__construct();
        setCurrentApplication('build_app');
    }

    public function index()
    {
        $requiredcss = [
            ['angularjs-ui/angular-ui.css']
        ];

        $this->carabiner->css($requiredcss);

        $requiredAngularjs = [
            ['node_modules/underscore/underscore-min.js'],
            ['node_modules/angular/angular.min.js'],
            ['node_modules/angular-cookies/angular-cookies.min.js'],
            ['node_modules/angular-route/angular-route.min.js'],
            ['node_modules/angular-sanitize/angular-sanitize.min.js'],
            ['libs/angularjs-ui/ui-bootstrap-tpls-0.9.0.min.js'],
            ['libs/class.js']
        ];

        $requiredjs = [
            ['libs/baseclasses/BaseController.js'],
            ['libs/baseclasses/EventDispatcher.js'],
            ['libs/baseclasses/Notifications.js'],
            ['buildApp/constants.js'],
            ['buildApp/app.js'],
            ['buildApp/controllers/baseBuildController.js'],
            ['buildApp/controllers/projectsController.js'],
            ['buildApp/controllers/modulesListController.js'],
            ['buildApp/controllers/modulesPageController.js'],
            ['buildApp/services/projectsService.js'],
            ['buildApp/services/modulesService.js'],
            ['buildApp/services/sshKeyService.js'],
            ['buildApp/services/masterfilesVersionService.js'],
            ['hostInfo/services/cmdbService.js'],
            ['hubManagement/services/hubManagementService.js'],
            ['common_directives/actions/actionService.js'],
            ['buildApp/directives/moduleData.js'],
        ];

        $this->carabiner->js($requiredAngularjs, $requiredAngularjs, $combine = true, $minify = false);
        $this->carabiner->js($requiredjs, $requiredjs, $combine = true, $minify = true);

        $data = ['title' => 'Mission Portal - Build'];

        $this->load->model('ProfileModel');
        $this->ProfileModel->setAdditionalData($this->session->userdata('username'), ProfileModel::BUILD_APP_OPENED_KEY, true);

        if (isInternetConnectionAvailable()) {
            $this->template->load('template', 'build_app/index', $data);
        } else {
            $this->template->load('template', 'build_app/network_error', $data);
        }
    }

    public function partials($dir, $partial)
    {
        $view = addslashes($dir) . '/' . addslashes($partial) . '.php';
        $this->load->view($view);
    }
}
