<?php
// show system error
if (!empty($sys_messages))
{
    foreach ($sys_messages as $type => $txt)
    {
        echo '<div class="alert ' . $type . '">' . $txt . '</div>';
    }
}
else
{
    ?>
    <?php include 'userListViewToggle.php'; ?>

    <?php if (!empty($users))
    { ?>
        <table id="users_table" class="table table-horizontal table-hover ">
            <thead>
                <tr>
                    <th>Users</th>
                     <?php if($showUsers == 'external') { ?>
                    <th>Status <i rel="tooltip" id="tab-context-help-icon" class="CFE-context-help help icon-question-sign"  data-original-title="A status of Authenticated means the user has previously logged in. An empty status indicates the user is allowed to log in but has not yet successfully authenticated."> </i></th>
                     <?php } ?>
                    <th>Email</th>
                    <th style="min-width: 120px">Roles</th>
                    <?php if($showUsers == 'external') { ?>
                    <th>Other LDAP groups</th>
                    <?php } ?>
                    <th class="right actions">Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php
                $loggedinusername = isset($username) ? $username : $this->session->userdata('username');
                foreach ((array) $users as $user)
                {

                    $username = isset($user['id']) ? $user['id'] : $user['name'];
                    $systemUsers = array('CFE_ROBOT');
                    if (in_array($username,$systemUsers))
                    {
                     continue;
                    }

                    ?>
                    <tr>
                        <td><div class="flex flex--align_center">
                                <?= htmlspecialchars($username) ?> 
                                <?= isset($user['two_factor_enabled']) && $user['two_factor_enabled'] ? '<span class="badge badge-xl badge-success-inverse badge-small_margin">2fa</span>' : '' ?>
                                <?= isset($user['external']) && $user['external'] ? '<span class="badge badge-xl badge-info-inverse badge-small_margin">LDAP</span>' : '' ?>
                                <?= isset($user['locked']) && $user['locked'] ? '<span class="badge badge-xl badge-important-inverse badge-small_margin">Locked</span>' : '' ?>
                            </div></td>
                        <?php if($showUsers == 'external'){ ?> <td><?php if($user['isLogged'] ){ ?>Authenticated<?php } ?></td> <?php } ?>
                        <td><?php echo isset($user['email']) ? $user['email'] : ""; ?></td>
                        <?php $roles_str = implode(', ', $user['roles']); ?>
                        <td>
                            <?php foreach ($user['roles'] as $index => $role) { ?>
                                <a
                                        href="/auth/manage_role/edit/<?= rawurlencode($role) ?>"
                                        class="edit_role <?= in_array($role, $ldapRolesToSync) ? '' : 'bold' ?>"
                                        title="edit role"
                                        form="role">
                                    <?= $role ?></a><?= isset($user['roles'][($index + 1)]) ? ',' : ''  ?>

                            <?php } ?>
                        </td>

                        <?php if($showUsers == 'external'){ ?>
                            <td>
                                <?php foreach ($user['ldapGroups'] as $index => $group) { ?>
                                        <?php if (in_array($group, $roles)) { ?>
                                            <a
                                                href="/auth/manage_role/edit/<?= rawurlencode($group) ?>"
                                                class="edit_role"
                                                title="edit role"
                                                form="role"><?= htmlspecialchars($group) ?></a><?= isset($user['ldapGroups'][($index + 1)]) ? ',' : ''  ?>
                                        <?php } else { ?>
                                            <a
                                                href="/auth/manage_role/create/<?= rawurlencode($group) ?>"
                                                class="add_role"
                                                title="create role"
                                                form="role"><?= htmlspecialchars($group) ?></a><?= isset($user['ldapGroups'][($index + 1)]) ? ',' : ''  ?>
                                        <?php } ?>
                                <?php } ?>
                            </td>
                        <?php } ?>



                            <?php if (isActionAllowed('user.post'))
                            { ?>

                                <td class="right">
                                <?php if((isset($user['isLogged']) && $user['isLogged']) || $showUsers !== 'external') { ?>
                                    <a data-toggle="modal" class="edit edit_user" title="Edit user" id="<?php echo $username ?>" href="javascript:void(0)"></a>
                                <?php } ?>
                                <?php

                                if (!$user['external'])
                                {
                                    if ($user['id'] != $loggedinusername)
                                    {
                                        ///if ($username != $fall_back_for) { // if this is not "admin" user
                                        ?>
                                        <a href="<?php echo site_url("auth/delete_user/") . $user['id'] ?>" class="remove" entityName="user" action-link="/settings/user-management" title="remove user"></a>
                                        <?php
                                        // }
                                    }
                                    elseif ($user['id'] == $loggedinusername)
                                    {
                                        ?>
                                        <a data-toggle="modal" class="change_password" title="change password" id="<?= htmlspecialchars($username) ?>" href="javascript:void(0)">change password</a>

                                    <?php
                                    }
                                } else {

                                } ?>
                                </td>
                            <?php
                            } ?>


                    </tr>
            <?php }
        ?>
            </tbody>
        </table>
            <?php

                $data['pg'] = paging($current, $number_of_rows, $totalUsers, 5);
                $data['url'] = 'settings/user-management';
                $data['params'] = '/users/' . $showUsers . '/';
                ?>
            <div class="row-fluid">
                <?php

                if(!isset($search)) {
                    $this->load->view('searchpages/paging_footer.php', $data);
                }

                ?>
            </div>

        <?php }
        else
        { ?>
        <div id="infoMessage" class="alert alert-warning">
        <?= $this->lang->line('nothing_found'); ?>
        </div>
    <?php } ?>
<?php } ?>


<script type="text/javascript">
$('.edit_user').click(function() {
    var userModalBody = {
        'header':'<h2>Edit user</h2>',
        'body_url': MP_SITE_URL + '/auth/edit_user/' + $(this).attr("id"),
        'onEscape': function(){}
    };

    $("<div></div>")
        .dialog_modal({passedArgs: ['',[],userModalBody], addBodyClass: 'form-buttons' });
});

$('.change_password').click(function(event) {
    if (event.isDefaultPrevented()) {
        return;
    }
    
    var userModalBody = {
        'header':'<h2>Change password</h2>',
        'body_url': MP_SITE_URL + '/auth/password_form',
        'onEscape': function(){}
    };

    $("<div></div>")
        .dialog_modal({passedArgs: ['',[],userModalBody], addBodyClass: 'form-buttons' });
});


</script>

<style>
   #users_table .tooltip-inner {max-width: 100%}
</style>

<?php
    if ($this->session->userdata("defaultadmin"))
    {
        echo '<script type="text/javascript">';
        echo '$(document).ready(function(){$(".change_password").trigger("click")});';
        echo '</script>';
    }

?>

