/**

NAME
====

Joose.Manual.JooseX - Recommended Joose extensions

JooseX?
=======

It's easy to extend and change Joose, and this is part of what makes Joose so powerful. You can use the meta API to do things your own way, add new features, and generally customize your Joose.

Writing your own extensions does require a good understanding of the meta-model. 
You can start learning about it from this [blog post](http://joose.it/blog/2010/10/03/joose-3-internals-part-i-meta-layers/). 
There are also several extension recipes in the [Joose.Cookbook][cookbook].

Explaining how to write extensions is beyond the scope of this manual. Fortunately, lots of people have already written extensions and put them on JSAN for you.

This document covers a few of the ones we like best.


Joose.Attribute
================

If you only look at one extension, it should be this one. It provides a lot of additional features for class's attributes, including lazy initialization, 
triggering, delegation and much more.

This lets you create much cleaner and fluent APIs.

        Class('User', {
            has : {
                orders : {
                    isa : Collection.Orders,
                
                    handles : {
                        addOrder : 'add'
                    }
                }
            }
        })
        
        -instead of-
        
        Class('User', {
            has : {
                orders : null 
            },
            
            methods : {
                addOrder : function (order) {
                    this.orders.add(order)
                }
            }
        })

For further reading please refer to [Joose.Attribute][attributex]


JooseX.Namespace.Depended
=========================

This is very flexible implementation of dependency handling system for Joose classes, suitable for usage in production environments. 
It integrates directly into class creation process, and supports versioning:

        Class('User', {
            VERSION : 1.23,
        
            isa : {
                Person : 1.15
            },
            
            does : {
                Administrator : 1.01
            }
            
            use : [ 'DashBoard.Reports' ],
            
            methods : {
                generateReport : function () {
                    var report = new DashBoard.Report()
                }
            }
        })

The most interesting feature of `JooseX.Namespace.Depended` is a special "grouped" loading mode, in which it can load a class with any number of recursive dependencies (in-depth) with only 2 http requests
(requires a server-side component). 
 
`JooseX.Namespace.Depended` supports several transport layers (&lt;script&gt; tag, sync/async xhr, ServerJS), resource types (JavaScript, CSS, etc) and its very easy to add your own.

For further reading please refer to [JooseX.Namespace.Depended][depended]


JooseX.Bridge.Ext
=================

If you are looking for DOM bindings library, running on Joose this extensions is right for you.

It replaces native class system of ExtJS framework with the Joose. The whole process is transparent for user and allows to write ExtJS classes using all capabilities of Joose:

        Class('Test.Run.Harness.Browser.UI.TestGrid', {
            
            isa : Ext.grid.GridPanel,
            
            does : ExtX.grid.Grouped,
            
            have : {
                harness : null
            },
            
            before : {
                initComponent : function () {
                    this.addEvents('rowselect')
                    
                    ...
                }
            },
            
            after : {
                initComponent : function () {
                    this.getSelectionModel().on('rowselect', this.onRowSelect, this)
                    
                    ....
                }
            },
            
            methods : {
                onRowSelect : function (selModel, indx, record) {
                    this.fireEvent('rowselect', this, record)
                }
            }
        })

For further reading please refer to [JooseX.Bridge.Ext][bridge]


JooseX.Types
============

Yet to be ported from Joose 2.x


AUTHOR
======

Nickolay Platonov [nickolay8@gmail.com](mailto:nickolay8@gmail.com)

Heavily based on the original content of Moose::Manual, by Dave Rolsky [autarch@urth.org](mailto:autarch@urth.org)


COPYRIGHT AND LICENSE
=====================

Copyright (c) 2008-2011, Malte Ubl, Nickolay Platonov

All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the documentation and/or other materials provided with the distribution.
* Neither the name of Malte Ubl nor the names of its contributors may be used to endorse or promote products derived from this software without specific prior written permission. 

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. 

[cookbook]: ../Cookbook.html
[attributex]: http://samuraijack.github.com/JooseX-Attribute
[depended]: http://samuraijack.github.com/JooseX-Namespace-Depended
[bridge]: http://samuraijack.github.com/joosex-bridge-ext

*/
