import type { ReactHTML } from "./tools/ReactHTML";
import type { ReactComponent } from "./tools/ReactComponent";
import type { CSSObject } from "./types";
import type { EmotionCache } from "@emotion/cache";
export declare function createWithStyles<Theme>(params: {
    useTheme: () => Theme;
    cache?: EmotionCache;
}): {
    withStyles: {
        <C extends keyof import("./tools/ReactHTML").JSXIntrinsicElements | ReactComponent<any>, Props extends C extends ReactComponent<infer P> ? P : C extends keyof import("./tools/ReactHTML").JSXIntrinsicElements ? ReactHTML[C] extends ReactComponent<infer P_1> ? NonNullable<P_1> : never : never, CssObjectByRuleName extends Props extends {
            classes?: Partial<infer ClassNameByRuleName> | undefined;
        } ? { [RuleName in keyof ClassNameByRuleName]?: CSSObject | undefined; } : {
            root: CSSObject;
        }>(Component: C, cssObjectByRuleNameOrGetCssObjectByRuleName: CssObjectByRuleName | ((theme: Theme, props: Props, classes: Record<keyof CssObjectByRuleName, string>) => CssObjectByRuleName), params?: {
            name?: string | Record<string, unknown> | undefined;
            uniqId?: string | undefined;
        } | undefined): C extends keyof import("./tools/ReactHTML").JSXIntrinsicElements ? ReactHTML[C] : C;
        getClasses: typeof getClasses;
    };
};
declare function getClasses<Classes>(props: {
    className?: string;
    classes?: Classes;
}): Classes extends Record<string, unknown> ? Classes extends Partial<Record<infer K, any>> ? Record<K, string> : Classes : {
    root: string;
};
export {};
