#!/bin/bash

set -e

# create the users
id cfapache >/dev/null 2>&1 || useradd -ms /bin/bash cfapache
id cfpostgres >/dev/null 2>&1 || useradd -ms /bin/bash cfpostgres

# assign the correct permissions to the mission-portal files
chown cfapache:cfapache /var/cfengine/share/GUI -R

# autogenerate /secrets.ini if it doesn't exist
pwgen() {
    dd if=/dev/urandom bs=1024 count=1 2>/dev/null | tr -dc 'a-zA-Z0-9' | fold -w $1 | head -n 1
}
SECRETS_INI=/var/cfengine/httpd/secrets.ini
if ! [ -f "${SECRETS_INI}" ]; then
    CF_ROBOT_PASSWORD=${CF_ROBOT_PASSWORD:-$(pwgen 32)}
    MP_CLIENT_SECRET=${MP_CLIENT_SECRET:-$(pwgen 32)}
    LDAP_API_SECRET=${LDAP_API_SECRET:-$(pwgen 32)}
    CFE_SESSION_KEY=${CFE_SESSION_KEY:-$(pwgen 32)}
    cat >"${SECRETS_INI}" <<EOF
[passwords]
cf_robot_password=${CF_ROBOT_PASSWORD}
[tokens]
mp_client_secret=$MP_CLIENT_SECRET
ldap_api_secret=$LDAP_API_SECRET
CFE_SESSION_KEY=$CFE_SESSION_KEY
EOF
    echo "Done creating $SECRETS_INI file"
fi

# set up PostgreSQL's pg_hba.conf file
cat >/etc/postgresql/13/main/pg_hba.conf <<EOF
local   all             postgres                                trust
local   all             all                                     trust
host    all             all             127.0.0.1/32            trust
host    all             all             ::1/128                 trust
EOF
service postgresql restart

# install PostgreSQL schemas and data
if ! [ -f /postgresql.initialized ]; then
    psql -U postgres -h localhost -c "CREATE USER cfapache WITH SUPERUSER;" || true
    psql -U postgres -h localhost -c "CREATE USER cfpostgres WITH SUPERUSER;" || true
    psql -U postgres -h localhost -c "CREATE USER cfmppostgres WITH SUPERUSER;" || true
    psql -U postgres -h localhost -c "CREATE USER root WITH SUPERUSER;" || true
    psql -U postgres -h localhost -c "CREATE DATABASE cfdb;" || true
    psql -U postgres -h localhost -c "CREATE DATABASE cfmp;" || true
    psql -U postgres -h localhost -c "CREATE DATABASE cfsettings;" || true
    cat /northern.tech/cfengine/nova/db/schema.sql /northern.tech/cfengine/nova/db/ootb_import.sql | psql -U cfpostgres -h localhost cfdb
    cat /northern.tech/cfengine/nova/db/schema_settings.sql /northern.tech/cfengine/nova/db/ootb_settings.sql | \psql -U cfpostgres -h localhost cfsettings
    cat /northern.tech/cfengine/mission-portal/phpcfenginenova/pgschema.sql /northern.tech/cfengine/mission-portal/phpcfenginenova/ootb_import.sql | psql -U postgres -h localhost cfmp
    echo "UPDATE oauth_clients SET client_secret='$(grep mp_client_secret= /var/cfengine/httpd/secrets.ini | cut -d"=" -f2)';" | psql -U postgres -h localhost cfsettings
    touch /postgresql.initialized
fi

# bootstrap the hub
if ! [ -f "/var/cfengine/ppkeys/localhost.pub" ]; then
    /var/cfengine/bin/cf-key
fi
/var/cfengine/bin/cf-agent --bootstrap ${HUB_IP:-"192.168.100.90"}
if [ -f "/var/cfengine/httpd/logs/httpd.pid" ]; then
    kill $(cat /var/cfengine/httpd/logs/httpd.pid)
fi
systemctl restart cfengine3

find /var/cfengine/httpd/htdocs/application/ -type d -exec chmod 750 {} \;
find /var/cfengine/httpd/htdocs/application/ -type f -exec chmod 640 {} \;
chown root:cfapache /var/cfengine/httpd/htdocs/application/ -R

/var/cfengine/httpd/php/bin/php /var/cfengine/httpd/htdocs/public/index.php cli_tasks create_cfe_robot_user
