import type { EmotionCache } from "@emotion/cache";
export type { CSSInterpolation, CSSObject, Css, Cx, CxArg } from "./types";
import { createMakeStyles, TssCacheProvider } from "./makeStyles";
export { createMakeStyles, TssCacheProvider };
import { createWithStyles } from "./withStyles_compat";
export { createWithStyles };
import { createTss } from "./tss";
export { createTss };
export type { Tss } from "./tss";
/** @see <https://docs.tss-react.dev/api/keyframes> */
export { keyframes } from "@emotion/react";
/** @see <https://docs.tss-react.dev/api/globalstyles> */
export { GlobalStyles } from "./GlobalStyles";
/** @see <https://docs.tss-react.dev/api/makestyles> */
export declare function createMakeAndWithStyles<Theme>(params: {
    useTheme: () => Theme;
    cache?: EmotionCache;
}): {
    withStyles: {
        <C extends keyof import("./tools/ReactHTML").JSXIntrinsicElements | import("./tools/ReactComponent").ReactComponent<any>, Props extends C extends import("./tools/ReactComponent").ReactComponent<infer P> ? P : C extends keyof import("./tools/ReactHTML").JSXIntrinsicElements ? import("./tools/ReactHTML").ReactHTML[C] extends import("./tools/ReactComponent").ReactComponent<infer P_1> ? NonNullable<P_1> : never : never, CssObjectByRuleName extends Props extends {
            classes?: Partial<infer ClassNameByRuleName> | undefined;
        } ? { [RuleName in keyof ClassNameByRuleName]?: import("./types").CSSObject | undefined; } : {
            root: import("./types").CSSObject;
        }>(Component: C, cssObjectByRuleNameOrGetCssObjectByRuleName: CssObjectByRuleName | ((theme: Theme, props: Props, classes: Record<keyof CssObjectByRuleName, string>) => CssObjectByRuleName), params?: {
            name?: string | Record<string, unknown> | undefined;
            uniqId?: string | undefined;
        } | undefined): C extends keyof import("./tools/ReactHTML").JSXIntrinsicElements ? import("./tools/ReactHTML").ReactHTML[C] : C;
        getClasses: <Classes>(props: {
            className?: string | undefined;
            classes?: Classes | undefined;
        }) => Classes extends Record<string, unknown> ? Classes extends Partial<Record<infer K, any>> ? Record<K, string> : Classes : {
            root: string;
        };
    };
    makeStyles: <Params = void, RuleNameSubsetReferencableInNestedSelectors extends string = never>(params?: {
        name?: string | Record<string, unknown> | undefined;
        uniqId?: string | undefined;
    } | undefined) => <RuleName_1 extends string>(cssObjectByRuleNameOrGetCssObjectByRuleName: Record<RuleName_1, import("./types").CSSObject> | ((theme: Theme, params: Params, classes: Record<RuleNameSubsetReferencableInNestedSelectors, string>) => Record<RuleNameSubsetReferencableInNestedSelectors | RuleName_1, import("./types").CSSObject>)) => (params: Params, muiStyleOverridesParams?: {
        props: Record<string, unknown>;
        ownerState?: Record<string, unknown> | undefined;
    } | undefined) => {
        classes: Record<RuleName_1, string>;
        theme: Theme;
        css: import("./types").Css;
        cx: import("./types").Cx;
    };
    useStyles: () => {
        theme: Theme;
        css: import("./types").Css;
        cx: import("./types").Cx;
    };
};
export declare const tss: import("./tss").Tss<{}, Record<never, unknown>, never, Record<string, unknown>, never>;
export declare const useStyles: import("./tss").Tss.UseStyles<{}, Record<never, unknown>, never, Record<string, unknown>>;
