<?php
require_once 'AlertSQL.php';

class CustomAlert extends AlertSQL
{

    /**
     * @var HttpClientInterface
     */
    private $restClient;

    function __construct()
    {
        parent::__construct();
    }

    public function setRestClient(HttpClientInterface $client)
    {
        $this->restClient = $client;
    }


    /**
     * @param $alert
     * @param $rule
     * @param $includes
     * @param $excludes
     * @return int
     */
    function getCustomStatus($alert, $rule, $includes, $excludes)
    {
        $data = [
            'query' => $rule->customConditions['sql'],
            'hostContextInclude' => $includes,
            'hostContextExclude' => $excludes
        ];

        $response = $this->restClient->post('/query', $data);
        $response = json_decode($response, JSON_OBJECT_AS_ARRAY);

        $failHosts = sizeof(reset($response["data"])['rows']);
        $totalHosts = $this->ci->host_model->getHostCountByContext($alert->username, $includes);

        $alertStatus['status'] = $failHosts > 0 ? 'fail' : 'success';
        $alertStatus['failHosts'] = $failHosts;
        $alertStatus['totalHosts'] = $totalHosts;

        return $alertStatus;
    }

    public function getCountFailHosts($alert, $rule)
    {
        $includes = $this->utils_getIncludesFromAlert($alert);
        $excludes = $this->utils_getExcludesFromAlert($alert);
        $data = [
            'query' => $rule->customConditions['sql'],
            'hostContextInclude' => $includes,
            'hostContextExclude' => $excludes
        ];

        $response = $this->restClient->post('/query', $data);
        $response = json_decode($response, JSON_OBJECT_AS_ARRAY);

        $failHosts = reset($response["data"])['rows'];

        return sizeof($failHosts);
    }

    public function getHostListWithHeader($alert, $rule, $limit)
    {

        $includes = $this->utils_getIncludesFromAlert($alert);
	    $excludes = $this->utils_getExcludesFromAlert($alert);

        $data = [
            'query' => $this->addHostNameToQuery($rule->customConditions['sql']),
            'hostContextInclude' => $includes,
            'hostContextExclude' => $excludes,
	        'limit' => $limit
        ];

	    $response = $this->restClient->post( '/query', $data );
        $response = json_decode($response, JSON_OBJECT_AS_ARRAY);

        $result = array();
        $result['header'] = $response["data"][0]['header'];
        $result['rows'] = $response["data"][0]['rows'];
        return $result;
    }


	private function addHostNameToQuery( $userQuery ) {
    	$queryWithHostname = 'SELECT hosts.HostName AS "Host name",  UserQueryData .* FROM hosts INNER JOIN  (' . $userQuery . ') AS UserQueryData ON UserQueryData.hostkey = hosts.hostkey';
		return $queryWithHostname;
	}

	public function getStatSqlString( $rule )
	{
		return 'SELECT Hosts.HostKey AS "hostkey" FROM hosts INNER JOIN (' . $rule->customConditions['sql'] . ') as subquery ON subquery.hostkey = Hosts.HostKey';
    }


}