<!DOCTYPE html>
<html ng-csp="no-unsafe-eval" class="<?= getThemeClass() ?>" xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="x-ua-compatible" content="IE=Edge"/>
<noscript>
  <META HTTP-EQUIV="Refresh" CONTENT="0;URL=<?php echo base_url()?>/disabled.html">
</noscript>
<meta http-equiv="Content-Type" content="text/html;charset=utf-8" />
<meta name="google" content="notranslate" />
<meta http-equiv="Content-Language" content="en_US" />
<title><?= htmlspecialchars($title ?? '') ?></title>
<script type="text/javascript">
    var CFE_MAJOR_MINOR_VERSION ="<?php echo CFE_MAJOR_MINOR_VERSION;?>";
    var MP_BASE_URL ="<?php echo base_url(); ?>";
    var MP_SITE_URL ="<?= rtrim(site_url(), '/') ?>";
    var MP_USER_TIMEZONE = "<?php echo $this->session->userdata('user_timezone'); ?>";
    var MP_USER_PROMISE_FILTER = "<?php echo $this->session->userdata('promisesfilter_mode'); ?>";
    var MP_LOG_JS_ERROR = <?= $this->config->item('log_js_errors') == true ? 'true' : 'false' ?>;

</script>

<link type="text/css" rel="stylesheet" href="<?php echo get_cssdir(); ?>museo.css" media="screen" />
<link type="text/css" rel="stylesheet" href="<?php echo get_cssdir(); ?>museo-variants.css" media="screen" />

<link rel="icon" href="/images/favicon.svg">

<?php
    // output default scripts which set in carabiner.php
    $this->carabiner->display('CFEngine','css');
     // output default scripts which set in single controller
    $this->carabiner->display('css');
    $this->carabiner->display('CFEngine','js');
    $this->carabiner->display('js');
?>

<?php include('custom_styles.php');?>
<!--[if IE]><?php
    // fixes for canvas
    $this->carabiner->display('iefix');
?><![endif]-->

<!--[if gte IE 9]><link type="text/css" rel="stylesheet" href="<?php echo get_cssdir(); ?>nonie8.css" media="screen" /><![endif]-->
<!--[if !IE]><!--><link type="text/css" rel="stylesheet" href="<?php echo get_cssdir(); ?>nonie8.css" media="screen" /><!--<![endif]-->

<!--[if lte IE 8]>
        <script>
          document.createElement('ng-include');
          document.createElement('ng-pluralize');
          document.createElement('ng-view');

          // Optionally these for CSS
          document.createElement('ng:include');
          document.createElement('ng:pluralize');
          document.createElement('ng:view');
        </script>
      <![endif]-->

</head>

<body class="<?= getThemeClass() ?> <?= getCurrentApplication() ?>">
<div id="globalSpinner" style="display: none;"><i class="icon icon-spinner icon-spin"></i></div>

<!--[if lte IE 7]><script src="<?php echo get_scriptdir() ?>/ieupgrade/warning.js"></script><script>window.onload=function(){e("<?php echo get_scriptdir() ?>/ieupgrade/")}</script><![endif]-->
 <div id="wrapper">
    <div class="navbar">
        <div class="container-fluid no-right-margin">
            <div class="logo">
                <?php
                $text = '<img src="'.base_url().'images/CFEngine_enterprise_logo'. (isDarkMode() == true ? '_dark' : '') .'.svg" alt="'.$this->lang->line('nova_logo_link_text').'" />';
                echo anchor("welcome/index", $text, array('id'=>'cfe_logo'));
                ?>
                <?php if (getCustomLogoFile('logo_on_header')) { ?><img style="max-height: 40px; margin-left: 10px" src="<?= getCustomLogoFile() ?>" /> <?php } ?>
            </div>

          <div id="global-host-search-root">
            </div>

            <div class="flex">
            <div tabindex="0" class="dropdown inline  CFE_HEALTH CFE_LICENSE_STATUS">
                <p class="dropdown-toggle ha_status_wrapper" style="padding-right:15px;" id="headerHostNumber" type="button" data-toggle="dropdown">
                    <span class="count total-host-count"></span>
                </p>
                <ul class="dropdown-menu unstyled" role="menu">
                    <li>
                        <div class="license_hover_info" style="padding:20px;">
                            <div>There is no information about the current license status.</div>
                        </div>
                    </li>
                    <li>
                        <hr />
                    </li>
                    <li style="padding-left: 20px;" class="padding-bottom detailed-host-count">
                        <h3>Detailed host counts</h3>
                        <div style="display: table-row;">
                            <span style="display: table-cell;">
                                Licenses
                            </span>
                            <span style="display: table-cell;" class="right detailed-license-count">
                                n/a
                            </span>
                        </div>
                        <div style="display: table-row;">
                            <span style="display: table-cell;">
                                Hosts
                            </span>
                            <span style="display: table-cell;" class="right detailed-hosts-count">
                                n/a
                            </span>
                        </div>
                        <div style="display: table-row;">
                            <span style="display: table-cell;">
                                Licensed hosts
                            </span>
                            <span style="display: table-cell;" class="right detailed-licensed-hosts-count">
                                n/a
                            </span>
                        </div>
                        <div style="display: table-row;">
                            <span style="display: table-cell;">
                                Hosts after RBAC-filtering
                            </span>
                            <span style="display: table-cell;" class="right detailed-filtered-hosts-count">
                                n/a
                            </span>
                        </div>
                        <div style="display: table-row;">
                            <span class="padding-right-x2" style="display: table-cell;">
                                Recently deleted hosts
                            </span>
                            <span style="display: table-cell;" class="right detailed-deleted-hosts-count">
                                n/a
                            </span>
                        </div>
                    </li>
                </ul>
            </div>

             <div tabindex="0" class="dropdown inline CFE_HEALTH hidden">
              <p class="dropdown-toggle" type="button" id="dropdownHealth" data-toggle="dropdown">
                <span class="headerHealthNumber">
                    Health
                    <span class="badge-wrapper"><a class="health-count"></a></span>
                </span>
              </p>

              <ul class="dropdown-menu connectivity-info" role="menu" aria-labelledby="dropdownHealth">
                <li class="health-header-links">
                    <?php if (isActionAllowed('HostsNeverCollectedReport.post')) { ?>
                    <a class="never-collected-error-link"   href="<?= site_url('reports/health-diagnostic/missing-reporting-data')?>">
                        <span>
                            Missing reporting data
                        </span>
                        <span style="display: table-cell;" class="right hosts-never-collected">
                            - <!-- get connection error number -->
                        </span>
                    </a>
                    <?php } ?>
                    <?php if (isActionAllowed('deletedHostsReportHD.post')) { ?>
                        <a class="deleted-hosts-report"   href="<?= site_url('reports/health-diagnostic/deleted-hosts-report')?>">
                        <span>
                            Deleted hosts still reporting
                        </span>
                            <span style="display: table-cell;" class="right deleted-hosts-report-error">
                            - <!-- get connection error number -->
                        </span>
                        </a>
                    <?php } ?>
                    <a class="connection-error-link"   href="<?= site_url('reports/health-diagnostic/unreachable-hosts')?>">
                        <span>
                            Unreachable hosts
                        </span>
                        <span style="display: table-cell;" class="right connection-error">
                            - <!-- get connection error number -->
                        </span>
                    </a>
                    <a class="agent-error-link"   href="<?= site_url('reports/health-diagnostic/outdated-reporting-data') ?>">
                        <span>
                            Outdated reporting data
                        </span>
                        <span style="display: table-cell;" class="right agent-not-run-recently">
                            - <!-- get connection error number -->
                        </span>
                    </a>
                    <a class="agent-error-link"   href="<?= site_url('reports/health-diagnostic/policy-errors') ?>">
                        <span>
                            Policy errors
                        </span>
                        <span style="display: table-cell;" class="right agent-error">
                            - <!-- get connection error number -->
                        </span>
                    </a>
                    <a class="agent-error-link"   href="<?= site_url('reports/health-diagnostic/duplicate-ids') ?>">
                        <span>
                            Duplicate IDs
                        </span>
                        <span style="display: table-cell;" class="right same-hosts-error">
                            - <!-- get connection error number -->
                        </span>
                    </a>
                    <a class="agent-error-link"   href="<?= site_url('reports/health-diagnostic/duplicate-hostnames') ?>">
                        <span>
                            Duplicate hostnames
                        </span>
                        <span style="display: table-cell;" class="right same-hosts-name-error">
                            - <!-- get connection error number -->
                        </span>
                    </a>
                </li>
              </ul>
            </div>

            <div  tabindex="0" class="dropdown inline CFE_HA_STATUS">
                <p class="dropdown-toggle ha_status_wrapper" type="button" data-toggle="dropdown">
                    <span>
                        Hub
                    </span>
                </p>
                <ul class="dropdown-menu hub-info-dropdown-menu" role="menu">
                    <li>
                        <div class="hub_hover_info">
                            <div>
                                <span>Version</span>:
                                <span class="hub_hover_info-version">
                                    <?= CFE_RELEASE_VERSION ?? 'n/a' ?>
                                </span>
                            </div>
                            <div>
                                <a
                                    class="hub_hover_info-link <?= HUB_KEY == null ? 'hide' : '' ?>"
                                    href="/hosts/<?= HUB_KEY ?>">
                                    Go to hub info page
                                </a>
                            </div>
                        </div>
                    </li>
                    <li>
                        <hr class="no-margin" />
                    </li>
                    <li>
                        <div class="ha_hover_info">
                            <div style="padding:20px;">There is no info about HA status yet</div>
                        </div>
                    </li>
                </ul>

            </div>

            <div  tabindex="0" class="dropdown inline">
                <p class="dropdown-toggle" type="button" id="dropdownMenu" data-toggle="dropdown">
                    <span>Hello, <?= htmlspecialchars($this->session->userdata('username')) ?></span>
                    <span><i class="bi bi-chevron-down"></i></span>
                </p>

                <ul class="dropdown-menu setting-top-menu" role="menu" aria-labelledby="dropdownMenu">
                    <li>
                        <a href="<?php echo site_url(isActionAllowed('settings.manage') ? 'settings/preferences' : 'settings/about'); ?>">
                            <div class="icon-wrap"><i class="bi bi-gear-fill margin-right"></i></div>
                            Settings
                        </a>
                    </li>
                    <li>
                        <a href="<?php echo site_url('settings/profile'); ?>">
                            <div class="icon-wrap"><i class="bi bi-person-fill margin-right"></i></div>
                            User profile
                        </a>
                    </li>
                    <li>
                        <a href="<?php echo site_url('docs/help'); ?>">
                            <div class="icon-wrap"><i class="bi bi-question-circle-fill margin-right"></i></div>
                            Help
                        </a>
                    </li>
                    <li>
                        <a href="<?php echo site_url('settings/about'); ?>">
                            <div class="icon-wrap"><i class="bi bi-info-circle-fill margin-right"></i></div>
                            About
                        </a>
                    </li>
                    <?= createAdditionalMenuLinks() ?>
                    <li>
                        <div class="dark-theme-switch">
                            <span class="margin-left-small">Dark mode</span>
                            <div class="checkbox-switch inline-block margin-left">
                                <input id="darkMode" onchange="darkModeToggle(this)" type="checkbox" <?= isDarkMode() == true ? 'checked' : '' ?>>
                                <label for="darkMode" class="label-orange"></label>
                            </div>
                        </div>
                    </li>
                    <li class="divider"></li>
                    <li>
                        <a id="logout" href="<?php echo site_url('login/logout'); ?>">
                            <div class="icon-wrap"><i class="bi bi-box-arrow-in-right margin-right"></i></div>
                            Log out
                        </a>
                    </li>
                </ul>
            </div>
            </div>
        </div>
    </div>

