<?php


class HostBootstrappedHandler extends BaseEventHandler
{
    protected function prepareEventEntity(EventEntity $eventEntity)
    {
        $payload = json_decode($this->eventData['payload']);
        $hostKey = isset($payload->hostkey) ? $payload->hostkey : 'undefined';
        $message = sprintf('Host with key %s was bootstrapped', $hostKey);
        $eventEntity
            ->setMessage($message)
            ->setTime($this->eventData['date'])
            ->setItemType(self::HOST_EVENT_TYPE)
            ->setItemName('Events API');
        return $eventEntity;
    }

}