/*jslint node: true */
/*jslint browser: true*/
/*jslint nomen: true*/
/*global BaseController, angular*/

'use strict';


const includeExcludeByHostkeyDirective = BaseController.extend({

    init: function ($scope, $attrs, $modal, IEPaginationService, naviTreeService, $timeout) {
        this.$modal = $modal;
        this.$timeout = $timeout;
        this.naviTreeService = naviTreeService;
        this._paginationService = IEPaginationService;
        this._super($scope);
    },

    defineScope: function () {
        this.$scope.showHost = this.showHost.bind(this);
        this.$scope.entriesList = this.entriesList.bind(this);
        this.$scope.intersectionsInclExcl = this.intersectionsInclExcl.bind(this);
        this.$scope.isEmptyObject = this.isEmptyObject;
        this.$scope.includedHostsCount = 0;
        this.$scope.includedEntriesCount = 0;
        this.$scope.excludedHostsCount = 0;
        this.$scope.excludedEntriesCount = 0;
        this.$scope.pluralize = pluralize;
        this.initialEntriesData = {
            hostkey: {},
            ip: {},
            ip_mask: {},
            hostname: {},
            mac: {}
        };
    },

    defineListeners: function () {
        this.$scope.$watch('includedHosts', entries => {
            this.$scope.includedEntriesCount = this.entriesCount(entries);
            this.$scope.includedEntriesData = angular.copy(this.initialEntriesData);
            if (this.$scope.includedEntriesCount > 0) {
                this.processEntriesData(entries, this.$scope.includedEntriesData);
            } else {
                this.$scope.includedHostsCount = 0;
            }
        }, true);

        this.$scope.$watch('excludedHosts', entries => {
            this.$scope.excludedEntriesCount = this.entriesCount(entries);
            this.$scope.excludedEntriesData = angular.copy(this.initialEntriesData);
            if (this.$scope.excludedEntriesCount > 0) {
                this.processEntriesData(entries, this.$scope.excludedEntriesData);
            } else {
                this.$scope.excludedHostsCount = 0;
            }
        }, true);

        this.$scope.$watch('includedEntriesData', entriesData => {
            this.$scope.includedHostskeys = this.entriesDataHosts(entriesData);
            this.$scope.includedHostsCount = this.$scope.includedHostskeys.length;
        }, true);

        this.$scope.$watch('excludedEntriesData', entriesData => {
            this.$scope.excludedHostskeys = this.entriesDataHosts(entriesData);
            this.$scope.excludedHostsCount = this.$scope.excludedHostskeys.length;
        }, true);
    },

    entriesDataHosts: function (entriesData) {
        let hosts = [];
        Object.values(entriesData).forEach((entry) => {
            Object.keys(entry).map(key => {
                const value = entry[key];
                if (Array.isArray(value)) {
                    value.map(v => hosts.push(v.hostkey))
                } else {
                    hosts.push(value.hostkey);
                }
            })
        })

        return hosts.uniqueOnly();
    },

    processEntriesData: async function (entries, entriesData) {
        const types = {
            ip: {op: 'or|contains', var: 'IPv4 addresses'},
            hostkey: {op: "or|matches", var: 'hostkey'},
            hostname: {op: "or|matches", var: 'Host name'},
            mac: {op: "or|contains", var: 'MAC addresses'},
            ip_mask: {op: "or|ip_mask", var: 'IPv4 addresses'},
        };
        let inventoryFilters = {};

        for (const type in types) {
            entries[type] = entries[type] || [];
            if (entries[type].length > 0) {
                inventoryFilters[types[type].var] = {};
                inventoryFilters[types[type].var][types[type].op] = entries[type];
            }
        }

        if (!Object.keys(inventoryFilters).length) return;
        await this.naviTreeService.getHostsByInventory(inventoryFilters).then(
            function (response) {
                for (const host of response.data.data) {
                    const {hostkey, hostname, ip} = host;
                    for (const hostkey of entries.hostkey) {
                        if (host.hostkey === hostkey) {
                            entriesData.hostkey[hostkey] = {hostkey, hostname};
                        }
                    }

                    for (const name of entries.hostname) {
                        if (host.hostname === name) {
                            entriesData.hostname[name] = {hostkey, hostname};
                        }
                    }

                    for (const ip of entries.ip) {
                        if (host.ip.includes(ip)) {
                            entriesData.ip[ip] = {hostkey, hostname};
                        }
                    }

                    for (const mac of entries.mac) {
                        if (host.mac.includes(mac)) {
                            entriesData.mac[mac] = {hostkey, hostname};
                        }
                    }

                    for (const ipMask of entries.ip_mask) {
                        if (host.ip.split(', ').find(ip => isIpAddressInSubnet(ip, ipMask))) {
                            entriesData.ip_mask[ipMask] = entriesData.ip_mask[ipMask] || [];
                            entriesData.ip_mask[ipMask].push({hostkey, hostname, ip});
                        }
                    }
                }
            });
    },

    showHost: function (include) {
        let self = this;
        self.$scope.include = include;
        this.hostListModalInstance = this.$modal.open({
            templateUrl: 'hostSelectionByNameModal.html',
            backdrop: 'static',
            keyboard: true,
            windowClass: 'include',
            controller: function ($scope, $modalInstance, $filter, $parent, $timeout, IEPaginationService, naviTreeService) {
                $scope.modalData = {
                    include: $parent.$scope.include,
                    selectedType: 'hostkey',
                    collapsedHost: '',
                    searchString: '',
                    queryIsIpMask: false,
                    queryIsIp: false,
                    queryIsHostname: false,
                    lastIncludedEntryType: null,
                    intersectionWarningMessage: 'This host is both included and excluded. Exclusion will take precedence.'
                };
                $scope.pluralize = pluralize;
                const defaultSearchResultCount = 8;

                $scope.entries = include ? angular.copy($parent.$scope.includedHosts) : angular.copy($parent.$scope.excludedHosts);

                $scope.entryTypes = ['hostkey', 'ip', 'hostname', 'mac'];

                $scope.hostsCount = 0;

                $scope.isEmptyObject = $parent.isEmptyObject;

                $scope.paginator = IEPaginationService;
                $scope.paginator.rowsPerPage = defaultSearchResultCount;

                const getNodeHostFailure = function (error) {
                    $scope.hostListError = error.data;
                    $scope.totalHostList = [];
                    $scope.showHosts = true;
                };

                const findSearchMatchesInHostAttributes = (data, searchString) => {
                    if (searchString.length > 0) {
                        $scope.totalHostList.forEach(data => {
                            for (const attr in data) {
                                if (!data[attr]) continue;
                                for (const value of data[attr].split(', ')) {
                                    if ($scope.modalData.queryIsIpMask) {
                                        // if search query is ip mask then find ip address that is in a subnet
                                        if (attr === 'ip' && isIpAddressInSubnet(value, searchString)) {
                                            data.searchTooltip = {attr, value, highlight: true};
                                        }
                                    } else if (value.includes(searchString)) {
                                        data.searchTooltip = {attr, value};
                                    }
                                }
                            }
                        });
                    }
                }

                const getNodeHostSuccess = function (result) {
                    const {data, meta} = result.data;
                    $scope.totalHostList = data;

                    findSearchMatchesInHostAttributes(data, $scope.modalData.searchString);

                    $scope.originalHostList = angular.copy($scope.totalHostList);
                    $scope.showHosts = true;
                    $scope.paginator.refreshPaginator(meta.rowCount);
                    $scope.totalHosts = meta.rowCount; // needed by paginator.page watch below
                };


                $scope.$watch('paginator.page', function (newPage, oldPage) {
                    if (newPage !== oldPage) {
                        naviTreeService.searchHostsByInventory($scope.modalData.searchString, defaultSearchResultCount, defaultSearchResultCount * ($scope.paginator.page - 1), $scope.modalData.queryIsIpMask).then(getNodeHostSuccess, getNodeHostFailure);
                        $scope.selectedHosts = {};
                        $scope.paginator.refreshPaginator($scope.totalHosts);
                    }
                })

                $scope.$watch('entries',
                    function (entries) {
                        $scope.entriesData = angular.copy($parent.initialEntriesData);
                        $parent.processEntriesData(entries, $scope.entriesData);
                    }, true
                )

                $scope.save = function () {
                    if ($parent.$scope.include) {
                        $parent.$scope.includedHosts = angular.copy($scope.entries);
                    } else {
                        $parent.$scope.excludedHosts = angular.copy($scope.entries);
                    }
                    setTimeout($parent.$scope.$parent.runReport, 0);
                    $scope.close();
                }

                let searchTimeout = null;

                // Search query validation patterns
                const VALIDATION_PATTERNS = {
                    IP: new RegExp('^((25[0-5]|(2[0-4]|1\\d|[1-9]|)\\d)\\.?\\b){4}$'),
                    IP_MASK: new RegExp('(\\b25[0-5]|\\b2[0-4][0-9]|\\b[01]?[0-9][0-9]?)(\\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)){3}\/([1-9]$|[1-2][0-9]$|3[0-2]$)'),
                    HOSTNAME: /^(([a-z0-9]|[a-z0-9][a-z0-9\-]*[a-z0-9])\.)*([a-z0-9]|[a-z0-9][a-z0-9\-]*[a-z0-9])$/
                };

                // Search debounce delay in milliseconds
                const SEARCH_DEBOUNCE_DELAY = 400;

                // Handle search query validation and API call
                const handleSearchQuery = (query) => {
                    $scope.modalData.collapsedHost = '';
                    // validate query type
                    const queryValidation = {
                        isIpMask: VALIDATION_PATTERNS.IP_MASK.test(query),
                        isIp: VALIDATION_PATTERNS.IP.test(query),
                        isHostname: VALIDATION_PATTERNS.HOSTNAME.test(query)
                    };

                    // update scope with validation results
                    Object.assign($scope.modalData, {
                        queryIsIpMask: queryValidation.isIpMask,
                        queryIsIp: queryValidation.isIp,
                        queryIsHostname: !queryValidation.isIp && queryValidation.isHostname
                    });

                    return naviTreeService.searchHostsByInventory(
                        query, 
                        defaultSearchResultCount, 
                        0, 
                        queryValidation.isIpMask
                    ).then(getNodeHostSuccess, getNodeHostFailure);
                };

                $scope.$watch('modalData.searchString', function(query) {
                    if (searchTimeout) {
                        $timeout.cancel(searchTimeout);
                    }
                    searchTimeout = $timeout(() => handleSearchQuery(query), SEARCH_DEBOUNCE_DELAY);
                }, true);

                $scope.$watch('entriesData', (entriesData) => {
                    $scope.hostsCount = $parent.entriesDataHosts(entriesData).length;
                }, true);

                $scope.addExcludedHost = function (host) {
                    $scope.excludedHosts[host.hostkey] = host.hostname;
                };

                $scope.ipMaskDescription = function (data, subnet) {
                    if (data === undefined) {
                        return 'There are currently no hosts in the database matching this entry, or they are not visible to you because of RBAC filtering.';
                    }

                    let description = data
                        .slice(0, 5) // use only first 5 items
                        .map(item => {
                            const ip = item.ip.split(', ').find(ip => isIpAddressInSubnet(ip, subnet));
                            return `${item.hostname} (IP: ${ip})`;
                        })
                        .join('\n ');

                    // add an ellipsis if data has more than 5 items
                    if (data.length > 5) {
                        description += "\n ...";
                    }

                    return description;
                };

                $scope.addEntry = function (entryType, value) {
                    if (!$scope.entries.hasOwnProperty(entryType)) {
                        $scope.entries[entryType] = [];
                    }
                    $scope.modalData.selectedType = entryType === 'ip_mask' ? 'ip' : entryType;
                    $scope.entries[entryType].unshift(value);
                    $scope.entries[entryType] = $scope.entries[entryType].uniqueOnly();
                    $scope.modalData.lastIncludedEntryType = entryType;
                };

                $scope.isEntryAdded = function (entryType, value) {
                    return $scope.entries[entryType]?.includes(value);
                };

                $scope.entriesCount = () => Object.values($scope.entries).reduce((accumulator, entries) => accumulator + entries.length, 0);

                $scope.removeEntry = (entryType, value) => setTimeout(() => {
                    $scope.entries[entryType] = $scope.entries[entryType].filter(item => item !== value);
                    $scope.modalData.lastIncludedEntryType = null;
                    $scope.$apply();
                }, 0);

                $scope.setCollapsedHost = function (event, host) {
                    setTimeout(() => event.target.closest('li')?.scrollIntoView({behavior: 'smooth'}), 50);
                    $scope.modalData.collapsedHost = host;
                };

                $scope.close = function () {
                    $modalInstance.close('cancel');
                };

                $scope.clearAll = function () {
                    $scope.entries = {};
                    $scope.entriesData = {
                        hostkey: {},
                        ip: {},
                        ip_mask: {},
                        hostname: {},
                        mac: {}
                    };
                }

                $scope.deleteExcludedHosts = function (hostkey) {
                    if ($scope.excludedHosts.hasOwnProperty(hostkey)) {
                        delete $scope.excludedHosts[hostkey];
                    }
                };

            },
            resolve: {
                naviTreeService: function () {
                    return self.naviTreeService;
                },
                $parent: function () {
                    return self;
                },

                $timeout: function () {
                    return self.$timeout;
                },
                paginationService: function () {
                    return self._paginationService;
                }
            }
        });
    },

    isEmptyObject: function (data) {
        return Object.keys(data).length == 0;
    },

    entriesCount: entries => Object.values(entries).reduce((acc, value) => acc += value.length, 0),

    intersectionsInclExcl: function () {
        return (Object.values(this.$scope.includedHostskeys).filter(item => Object.values(this.$scope.excludedHostskeys).includes(item)).length > 0);
    },

    // if the joined list of entries is greater than 75 characters truncate and add ellipsis
    entriesList: function (entries) {
        const list = Object.values(entries).reduce((acc, entry) => {
            if (entry.length > 0) {
                acc.push(...entry);
            }
            return acc;
        }, []).join(', ');
        return list.length > 75 ? list.substring(0, 75) + '...' :
            list;
    },
});
