import { Palette, ThemeOptions, autocompleteClasses, inputBaseClasses } from '@mui/material';
import { buttonClasses } from '@mui/material/Button';

import { blue, commonPalette, darkBackground, darkBlue, darkThemeText, gray, orange, overrides, typography } from './common';

const palette = {
  ...commonPalette,
  primary: {
    main: gray[600],
    light: blue[200],
    dark: gray[700],
    border: 'rgba(255, 255, 255, 0.12)'
  },
  secondary: {
    main: orange[800],
    light: darkBlue[700],
    dark: orange[850]
  },
  link: { primary: darkBlue[200], muted: gray[200]},
  text: {
    primary: darkThemeText,
    muted: gray[300]
  },
  background: {
    default: darkBackground[900],
    lightgrey: darkBackground[500],
    code: darkBackground[800]
  },
  border: {
    main: 'rgba(255, 255, 255, 0.12)'
  },
  mode: 'dark'
} as Palette;

export const dark: ThemeOptions = {
  palette,
  typography,
  components: {
    ...overrides,
    MuiTextField: {
      ...overrides.MuiTextField,
      styleOverrides: {
        ...overrides.MuiTextField.styleOverrides,
        root: {
          ...overrides.MuiTextField.styleOverrides.root
        }
      }
    },
    MuiAutocomplete: {
      styleOverrides: {
        ...overrides.MuiAutocomplete.styleOverrides,
        root: {
          ...overrides.MuiAutocomplete.styleOverrides.root,
          [`& .${autocompleteClasses.input}`]: {
            ...(overrides.MuiAutocomplete.styleOverrides.root[`& .${autocompleteClasses.input}`] as object),
            background: darkBackground[50],
            color: palette.text.primary,
            caretColor: palette.text.primary
          },
          [`& .${inputBaseClasses.input}::placeholder`]: {
            ...(overrides.MuiAutocomplete.styleOverrides.root[`& .${inputBaseClasses.input}::placeholder`] as object),
            color: palette.text.primary
          },
          ['.Mui-focused .MuiOutlinedInput-notchedOutline']: {
            border: `3px solid ${darkBlue[200]} !important`
          },
          '.MuiAutocomplete-option': {
            backgroundColor: darkBackground[50]
          }
        },
        popper: {
          ...overrides.MuiAutocomplete.styleOverrides.popper
        },
        noOptions: {
          ...(overrides.MuiAutocomplete.styleOverrides.noOptions as object),
          color: `${palette.text.primary} !important`,
          background: `${darkBackground[50]} !important`
        }
      }
    },
    MuiTooltip: {
      styleOverrides: {
        tooltipArrow: {
          ['> .MuiTooltip-arrow']: {
            color: gray[600]
          },
          background: gray[600]
        }
      }
    },
    MuiButton: {
      ...overrides.MuiButton,
      styleOverrides: {
        ...overrides.MuiButton.styleOverrides,
        root: {
          ...overrides.MuiButton.styleOverrides.root,
          [`&.${buttonClasses.colorSecondary}`]: {
            color: darkBackground[900]
          },
          [`&.${buttonClasses.disabled}`]: {
            color: 'rgba(255, 255, 255, 0.6)'
          }
        }
      }
    }
  }
};
