<?php

/**
 * Class DefaultImplementation
 */
class DefaultImplementation implements FormatInventoryFilterInterface
{
    /**
     * @param $value
     * @param $operator
     * @return mixed|string
     */
    public function getValueForWhere($value, $operator, \PDO $pdo)
    {
        switch ($operator) {
            case InventoryLib::IS_REPORTED_OPERATOR:
            case InventoryLib::IS_NOT_REPORTED_OPERATOR:
                $value = null;
                break;
            default:
                $value = $pdo->quote($value);
                break;
        }
        return $value;
    }

}
