/*jslint node: true */
/*jslint browser: true*/
/*jslint nomen: true*/
/*jslint plusplus: true */
/*global dashboardApp, angular, $*/

'use strict';

dashboardApp.factory('decommissionedHostsWidgetHelper',
    ['$q', 'decommissionedHostsService', '$window', '$location',
        function ($q, decommissionedHostsService, $window, $location) {
            let helper = {};
            let todayDate = new Date();
            let selectedDateRange = {};

            helper.goToEventsLog = function (daterange) {
                sessionStorage.removeItem('sql');
                var url = MP_SITE_URL + '/dashboard/eventlog?type=host&from=' + daterange.from + '&to=' + daterange.to;
                $window.location.href = url;
            }

            helper.chartConfig = {
                chart: {
                    type: 'line',
                    backgroundColor: 'transparent',

                    events: {
                        click: function (e) {
                            helper.goToEventsLog(selectedDateRange)
                        }
                    }
                },
                colors: [widgetColors.mainColor()],
                exporting: {
                    enabled: false
                },
                plotOptions: {
                    line: {
                        borderWidth: 0,
                        allowPointSelect: false,
                        cursor: 'pointer',
                        point: {
                            events: {
                                click: function () {
                                    helper.goToEventsLog({
                                        from: moment().startOf('day').subtract((6 - this.x), 'days').format("YYYY-MM-DD 00:00:00"),
                                        to: moment().startOf('day').subtract((5 - this.x), 'days').endOf('day').format("YYYY-MM-DD 23:59:59")
                                    });
                                }
                            }
                        }
                    }
                },
                tooltip: {
                    formatter: function () {
                        return 'Count: ' + this.y;
                    }
                },
                legend: {
                    enabled: false
                },
                series: [{
                    data: []
                }],
                title: {
                    text: ''
                },
                subtitle: {
                    text: ''
                },
                xAxis: {
                    categories: [],
                    title: {
                        text: null
                    },
                    allowDecimals: false
                },
                yAxis: {
                    allowDecimals: false,
                    min: 0,
                    title: {
                        text: 'Decommissioned host count'
                    }
                },
                credits: {
                    enabled: false
                },
                loading: false
            };
            helper.getChartConfig = function() {
                return {...helper.chartConfig, colors: [widgetColors.mainColor()]};
            }

            helper.getDecommissionedHostsStats = function (data, group) {
                selectedDateRange = {
                    from: moment(data.from).format("YYYY-MM-DD 00:00:00"),
                    to: moment(data.to).format("YYYY-MM-DD 23:59:59")
                }
                var promise = decommissionedHostsService.getHostCountStats({
                    'from': selectedDateRange.from,
                    'to': selectedDateRange.to,
                    'period': group
                }).then(
                    function (result) {
                        return result;
                    }
                );

                return promise
            };


            helper.convertArray = function (arr) {
                var returnData = {};
                returnData.array = [];
                returnData.axis = [];

                angular.forEach(arr, function (value, key) {
                    returnData.axis.push(value.date);
                    returnData.array.push(value.count);
                });

                return returnData;
            };

            helper.setChartData = function (changeStats) {

                var convertedData = helper.convertArray(changeStats);
                helper.chartConfig.series[0] = {
                    data: convertedData.array
                };
                helper.chartConfig.xAxis.categories = convertedData.axis;
            };

            helper.setChartData = function (changeStats) {

                var convertedData = helper.convertArray(changeStats);
                helper.chartConfig.series[0] = {
                    data: convertedData.array
                };
                helper.chartConfig.xAxis.categories = convertedData.axis;
            };

            helper.initDateRange = function () {
                return {
                    startDate: this._returnDate(6),
                    endDate: todayDate,
                    dateLimit: {days: 1},
                    maxDate: todayDate
                };
            };

            helper._returnDate = function (days, startOfDay) {
                var date = new Date(new Date().setDate(todayDate.getDate() - days));

                if (startOfDay === true) {
                    date.setHours(0, 0, 0, 0);
                }

                return date;
            };


            return helper;
        }]);
