import { createSelector } from '@reduxjs/toolkit';
import { CmdbState } from './index';

const selectCmdbState = (state: { cmdb: CmdbState }) => state.cmdb;

export const selectCmdbItems = createSelector(
    [selectCmdbState],
    cmdb => cmdb.items
);

export const selectCurrentItem = createSelector(
    [selectCmdbState],
    cmdb => cmdb.currentItem
);

export const selectJsonConfig = createSelector(
    [selectCmdbState],
    cmdb => cmdb.jsonConfig
);

export const selectCmdbLoading = createSelector(
    [selectCmdbState],
    cmdb => cmdb.loading
);

export const selectCmdbError = createSelector(
    [selectCmdbState],
    cmdb => cmdb.error
);

export const selectCmdbLoadingStates = createSelector(
    [selectCmdbState],
    cmdb => cmdb.loadingStates
);

export const selectIdentifier = createSelector(
    [selectCmdbState],
    cmdb => cmdb.identifier
);

export const selectCmdbServiceUrl = createSelector(
    [selectCmdbState],
    cmdb => cmdb.cmdbServiceUrl
);

export const selectAddedPolicyConfigurationsIds = createSelector(
    [selectCmdbState],
    cmdb => cmdb.policyConfigurationIds
);

export const selectPagination = createSelector(
    [selectCmdbState],
    cmdb => ({
        page: cmdb.page,
        perPage: cmdb.perPage,
        total: cmdb.total
    })
);
