<?php

/**
 * Created by PhpStorm.
 * User: ialeksandrychev
 * Date: 30.05.17
 * Time: 10:39
 */
class BaseTestClass extends PHPUnit_Framework_TestCase
{
    protected $db;

    public function __construct()
    {
        $this->db = DbConnection::getInstance()->getConnection();
        parent::__construct();
    }

    public function loadPostgresqlCFDBFixtures()
    {

        $tableArray = array(
            '__hosts' => array(),
            '__agentstatus' => array(),
            '__contexts' => array(),
            '__lastseenhosts' => array(),
            '__monitoringhg' => array(),
            '__monitoringmgmeta' => array('id'),
            '__softwareupdates' => array(),
            '__variables' => array(),
            'variables_dictionary' => array('id'),
        );

        foreach ($tableArray as $table => $sequenceFields) {
            $this->truncate($table);
            $path = __DIR__ . "/fixtures/cfdb/" . $table . '-data.sql';
            if (file_exists($path)) {
                $sql = sprintf('COPY  %s FROM \'%s\'', $table, $path);
                $this->db->query($sql);
                foreach ($sequenceFields as $seq) {
                    $seq = sprintf(
                        "SELECT setval('%s', (SELECT MAX(%s) FROM %s))",
                        $table . "_" . $seq . "_seq",
                        $seq,
                        $table
                    );
                    $this->db->query($seq);
                }
            }

        }
    }

    public function truncate($table)
    {
        $this->db->query('TRUNCATE TABLE ' . $table . ' RESTART IDENTITY CASCADE;');

    }

}
