'use strict';
/*
 * Service to work with http
 *
 **/
var reportServiceClass = Class.extend({
    ADV_REPORTS_URL:  MP_SITE_URL + '/advancedreports',
    FAVOURITE_REPORTS_URL:  MP_SITE_URL + '/FavouriteReports/report',
    loadReports: function(pagingData) {
        return this.$http({
            method: 'POST',
            headers : {
                'Content-Type':'application/x-www-form-urlencoded; charset=UTF-8'
            },
            url: this.ADV_REPORTS_URL + '/listsearches',
            data: pagingData,
            cache: false
        });
    },
    loadAllReports: function(pagingData) {
        return this.$http({
            method: 'POST',
            headers : {
                'Content-Type':'application/x-www-form-urlencoded; charset=UTF-8'
            },
            url: this.ADV_REPORTS_URL + '/listallsearches',
            data: pagingData,
            cache: false
        });
    },
    loadReport: function(id) {
        var report = this.ADV_REPORTS_URL + '/load/' + encodeURIComponent(id);
        return this.$http.get(report, {
            cache: false
        });
    },
    getReportByExportId: function(exportId) {
        const report = this.ADV_REPORTS_URL + '/report_by_export_id/' + encodeURIComponent(exportId);
        return this.$http.get(report, {
            cache: false
        });
    },
    loadInventoryAlert: function(id) {
        var report = this.ADV_REPORTS_URL + '/loadalert/' + encodeURIComponent(id);
        return this.$http.get(report, {
            cache: false
        });
    },
    runQuery: function(data) {
       return this.$http({
            method: 'POST',
            headers : {
                'Content-Type':'application/x-www-form-urlencoded; charset=UTF-8'
            },
            url: this.ADV_REPORTS_URL +'/results/',
            data: data,
            cache: false
        });
    },
    saveReport: function(data) {
        return this.$http({
            method: 'POST',
            headers : {
                'Content-Type':'application/x-www-form-urlencoded; charset=UTF-8'
            },
            url: this.ADV_REPORTS_URL + '/save',
            data: data,
            cache: false
        });
    },
    deleteReport: function(id) {
        var result = this.ADV_REPORTS_URL + '/delete/' + encodeURIComponent(id);
        return this.$http.delete(result, {
            cache: false
        });
    },
    saveScheduleForReport: function(data) {
        return this.$http({
            method: 'POST',
            headers : {
                'Content-Type':'application/x-www-form-urlencoded; charset=UTF-8'
            },
            url: this.ADV_REPORTS_URL + '/savescheduleforreport',
            data: data,
            cache: false
        });
    },
    loadSchedules: function(id) {
          return this.$http.get(this.ADV_REPORTS_URL + '/loadreportschedules/' + encodeURIComponent(id), {
            cache: false
        });
    },
    //data = reportid, scheduleid
    deleteSchedule: function(data) {
         return this.$http({
            method: 'POST',
            headers : {
                'Content-Type':'application/x-www-form-urlencoded; charset=UTF-8'
            },
            url: this.ADV_REPORTS_URL + '/deleteschedule',
            data: data,
            cache: false
        });
    },
    subscribeToReport: function(data) {
         return this.$http({
            method: 'POST',
            headers : {
                'Content-Type':'application/x-www-form-urlencoded; charset=UTF-8'
            },
            url: this.ADV_REPORTS_URL + '/subscribe',
            data: data,
            cache: false
        });
    },
    unsubscribeFromReport: function(data) {
         return this.$http({
            method: 'POST',
            headers : {
                'Content-Type':'application/x-www-form-urlencoded; charset=UTF-8'
            },
            url: this.ADV_REPORTS_URL + '/unsubscribe',
            data: data,
            cache: false
        });
    },
    copyReport: function(data) {
         return this.$http({
            method: 'POST',
            headers : {
                'Content-Type':'application/x-www-form-urlencoded; charset=UTF-8'
            },
            url: this.ADV_REPORTS_URL + '/copyReport',
            data: data,
            cache: false
        });
    },

    deleteHosts: function(listOfKeys)
    {
        var keys = listOfKeys || [];
        var data = $.param({'delhosts':keys});
        if (keys.length)
        {
          return this.$http({
            method: 'POST',
            url: MP_SITE_URL + '/host/delhosts',
            headers : {
                'Content-Type':'application/x-www-form-urlencoded; charset=UTF-8'
            },
            data: data,
            cache: false
        });
        }
        return false;
    },

    getInventoryFields: function(data) {
        var url = this.ADV_REPORTS_URL + '/getinventoryfields';
        return this.$http.get(url, {cache: false});
    },
    updateVariablesDictionary: function(fields) {
        var data = $.param({
            fields  : fields
        });
         return this.$http({
            method: 'POST',
            headers : {
                'Content-Type':'application/x-www-form-urlencoded; charset=UTF-8'
            },
            url: this.ADV_REPORTS_URL + '/updatevariablesdictionary',
            data: data,
            cache: false
        });
    },

    runChangesQuery: function(queryData) {
        var data = $.param(queryData);
        return this.$http({
            method: 'POST',
            headers : {
                'Content-Type':'application/x-www-form-urlencoded; charset=UTF-8'
            },
            url: this.ADV_REPORTS_URL + '/changes',
            data: data,
            cache: false
        });
    },

    updateComplianceScore: function(queryData) {
        return this.$http({
            method: 'POST',
            headers : {
                'Content-Type':'application/x-www-form-urlencoded; charset=UTF-8'
            },
            url: this.ADV_REPORTS_URL + '/complianceReport/score',
            data: $.param(queryData),
            cache: false
        });
    },

    getComplianceScore: function(ids) {
        return this.$http({
            method: 'GET',
            headers : {
                'Content-Type':'application/x-www-form-urlencoded; charset=UTF-8'
            },
            url: this.ADV_REPORTS_URL + '/complianceReport/score',
            params: {"ids[]": ids},
            cache: false
        });
    },

    importComplianceReport: function(data, overwrite) {
        return this.$http({
            method: 'POST',
            headers : {
                'Content-Type':'application/x-www-form-urlencoded; charset=UTF-8'
            },
            url: this.ADV_REPORTS_URL + '/complianceReport/import',
            data: $.param({data, overwrite, source: 'Import report UI'}),
            cache: false
        });
    },

    getTotalHostsCount: function (inclExcl) {
        let deferred = this.$q.defer();
        this.runQuery($.param({
            SQLString: 'SELECT COUNT(*) FROM hosts',
            ...inclExcl
        })).then(function (result) {
            deferred.resolve(result.data.rows[0][0]);
        });
        return deferred.promise;
    },

    addFavourite: function (reportId) {
        return this.$http({
            method: 'POST',
            url: `${this.FAVOURITE_REPORTS_URL}/${reportId}`,
            cache: false
        });
    },

    removeFavourite: function (reportId) {
        return this.$http({
            method: 'DELETE',
            url: `${this.FAVOURITE_REPORTS_URL}/${reportId}`,
            cache: false
        });
    },

    favouriteList: function () {
        return this.$http({
            method: 'GET',
            headers: {
                'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'
            },
            url: this.FAVOURITE_REPORTS_URL,
            cache: false
        });
    }
});

(function() {
    var reportServiceProvider = Class.extend({
        instance: new reportServiceClass(),
        $get: ['$http', '$q', function($http, $q) {
            this.instance.$http = $http;
            this.instance.$q = $q;
            return this.instance;
        }]
    });

    angular.module('reportServiceModule', [])
        .provider('reportService', reportServiceProvider);

}());