

        <?php
        if (($this->session->flashdata('message')) || (isset($message) && is_array($message)))
        {
            $flashMessage = $this->session->flashdata('message') ? $this->session->flashdata('message') : $message;
            $content = $flashMessage['content'];
            $content_class = $flashMessage['type'];
            ?>
            <div class="contentWrapper">
                <div style="margin-top: 13px;">
                    <div class="alert <?php echo $content_class; ?>">
                        <button class="close" data-dismiss="alert"><i class="bi bi-x"></i></button>
                        <?php echo $content; ?>
                    </div>
                </div>
            </div>
        <?php } ?>

        <div class="app-view">
            <div>
                <p>Status: <b><?php echo ($application['state'] == 'on' ? 'Enabled' : 'Disabled') ?></b></p>
                <?php
                    if (isset($application['meta']['description']))
                    {
                        echo "<p>". htmlspecialchars($application['meta']['description']) ."</p>";
                    }
                ?>

                <p>Visible on welcome page and in the apps list: <b><?php echo ($application['show_apps_list'] == '1' ? 'yes' : 'no') ?></b></p>
            </div>
            <div class="margin-top-large">
                <h3>Meta information:</h3>

                <?php
                    if (isset($application['meta']['license'])) {  ?>
                    <p>License: <a href="<?php echo $application['meta']['license'] ?>"><?= htmlspecialchars($application['meta']['license']) ?></a></p>
                <?php } ?>

                <?php
                    if (isset($application['meta']['copyright'])) {  ?>
                    <p>Copyright: <?= htmlspecialchars($application['meta']['copyright']) ?></p>
                <?php } ?>

                <?php
                    if (isset($application['meta']['author'])) {  ?>
                    <p>Author: <?= htmlspecialchars($application['meta']['author']['name']) ?>.
                       <?php echo (isset($application['meta']['author']['email']) ? '<span style="white-space:nowrap">E-mail: <a href="mailto:'. htmlspecialchars($application['meta']['author']['email']).'">'. htmlspecialchars($application['meta']['author']['email']).'</a>.</span>' : '' ) ?>
                       <?php echo (isset($application['meta']['author']['website']) ? '<span style="white-space:nowrap">Website: <a href="'. htmlspecialchars($application['meta']['author']['website']) .'">'. htmlspecialchars($application['meta']['author']['website']).'</a></span>' : '' ) ?></p>
                <?php } ?>

            </div>

            <?php if (isset($application['meta']['release'])) { ?>
            <div class="margin-top-large margin-bottom">
            <h3>Release:</h3>
               <table class="no-border no-hover">
                    <tr>
                        <td>Date:</td>
                        <td><?php echo date('d M Y', strtotime($application['meta']['release']['date'])) ?></td>
                    </tr>
                    <tr>
                        <td>Version:</td>
                        <td><?= htmlspecialchars($application['meta']['release']['version']) ?></td>
                    </tr>
                    <tr>
                        <td>Build:</td>
                        <td><?= htmlspecialchars($application['meta']['release']['build']) ?></td>
                    </tr>

                    <?php if (isset($application['meta']['supported'])) { ?>
                    <tr>
                        <td class="padding-right">Supported Mission Portal versions:</td>
                        <td>
                            <?php foreach ($application['meta']['supported'] as &$version) {
                                echo htmlspecialchars($version);
                                if(end($application['meta']['supported']) !== $version){
                                    echo ', '; // not the last element
                                }
                            }
                            ?>
                        </td>
                    </tr>
                    <?php } ?>


                </table>
            </div>
            <?php } ?>
        </div>

