var fimService = Class.extend({

    convertDiffToHtml: function (diff) {
        return this.$http({
            method: 'POST',
            url: MP_SITE_URL + '/advancedreports/fileIntegrityMonitoring/convertDiff',
            headers : {
                'Content-Type':'application/x-www-form-urlencoded; charset=UTF-8'
            },
            data: $.param({diff: diff}),
            cache: false
        });
    },
    searchFiles: function(query) {
        let url = MP_SITE_URL + '/advancedreports/fileIntegrityMonitoring/fileList?query=' + encodeURIComponent(query);
        return this.$http.get(url, {
            cache: false
        });
    }
});

(function () {
    var fimServiceProvider = Class.extend({
        instance: new fimService(),
        $get: ['$http', function ($http) {
            this.instance.$http = $http;
            return this.instance;
        }]
    });

    angular.module('fimService', [])
        .provider('fimService', fimServiceProvider);
}());