<?php
require_once APPPATH . 'libraries/Cf_REST_Controller.php';

class SharedGroupsCmdb extends Cf_REST_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model('sharedGroupCmdb_model');
    }

    public function items_get($groupId)
    {
        try {
            $limit = intval($_REQUEST['perPage'] ?? 6);
            $page = intval($_REQUEST['page'] ?? 1);
            $offset = ($page - 1) * $limit;
            $list = $this->sharedGroupCmdb_model->getItems($groupId, $offset, $limit);
            $this->respond(200, json_encode($list));
            return;
        } catch (Exception $exception) {
            log_message('error', 'Unable to get cmdb list. Error: ' . $exception->getMessage());
            throw $exception;
        }
    }

    public function item_post($groupId)
    {
        try {
            $data = json_decode($_REQUEST['data'], true);
            $list = $this->sharedGroupCmdb_model->createItem($groupId, $data);
            $this->respond(200, json_encode($list));
            return;
        } catch (Exception $exception) {
            log_message('error', 'Unable to update cmdb. Error: ' . $exception->getMessage());
            throw $exception;
        }
    }

    public function item_put($id)
    {
        try {
            preg_match('/data=(.*)$/', $this->_put_args, $matches);
            $data = urldecode($matches[1]);
            $list = $this->sharedGroupCmdb_model->updateItem($id, $data);
            $this->respond(200, json_encode($list));
            return;
        } catch (Exception $exception) {
            log_message('error', 'Unable to update cmdb. Error: ' . $exception->getMessage());
            throw $exception;
        }
    }

    public function item_get($groupId, $type, $name)
    {
        try {
            $item = $this->sharedGroupCmdb_model->getItemByName($groupId, $type, $name);
            $this->respond(200, $item);
            return;
        } catch (HttpClient_NotFound $exception) {
            $this->respond(404);
        } catch (Exception $exception) {
            log_message('error', 'Unable to get cmdb item. Error: ' . $exception->getMessage());
            throw $exception;
        }
    }

    public function item_delete($id)
    {
        try {
            $this->sharedGroupCmdb_model->deleteItem($id);
            return;
        } catch (Exception $exception) {
            log_message('error', 'Unable to delete cmdb item. Error: ' . $exception->getMessage());
            throw $exception;
        }
    }

    public function policy_configurations_ids_get($groupId)
    {
        try {
            $ids = $this->sharedGroupCmdb_model->getPolicyConfigurationIds($groupId);
            $this->respond(200, $ids);
            return;
        } catch (Exception $exception) {
            log_message('error', 'Unable to get policy configurations IDs. Error: ' . $exception->getMessage());
            throw $exception;
        }
    }
}
