// @ts-nocheck
import GeneralApi from '@northern.tech/store/api/general-api';
import { actions, sliceName } from '@northern.tech/store/usersSlice/index';
import { createAsyncThunk } from '@reduxjs/toolkit';

import { auditLogApiUrl } from '../constants';

export const getUserList = createAsyncThunk(`${sliceName}/getUserList`, (_, { dispatch }) =>
  GeneralApi.get(`${auditLogApiUrl}/actors`)
    .then(({ data = [] }) => {
      const users = data.reduce((accu, item) => {
        accu[item] = {
          id: item,
          email: item
        };
        return accu;
      }, {});
      return dispatch(actions.receivedUserList(users));
    })
    // eslint-disable-next-line no-undef
    .catch(() => notify.error(`Users couldn't be loaded.`))
);
