<?php

class CF_Alert {
    var $id;
    var $username;
    var $name;
    var $severity;
    var $ruleid;           // reference to the rule

    var $widgetid;         // reference to the widget
    var $widgetName;       // name of widget alert attached too

// status info
    var $lastStatusChange; // when alert change status from success to failure or vice versa  | timestamp
    var $lastCheck;        // last run time | timestamp
    var $lastEventTime;    // When event was created, used for reminder feature | timestamp
    var $status;           // current alert status - success, fail, internal_error

    var $failHosts;
    var $totalHosts;


    var $pause;            // numeric value or -1, which means that alert is paused indefinitely. Numeric value = time when alert was paused + timeout
    var $paused;           // 1 or 0

    var $serverTime;       // we need this to caclucate pause time

    var $emailToNotify;    // array of references to the notifications
    var $reminder;         // array of references to the notifications


    var $hostContextsProfileId;   // reference to the host filter profile
    var $hostContextsPath;        // reference to the nodes
    var $hostContexts;            // object contain name and includes array - JSON string in DB
    var $excludedHosts;            // object contain name and excludes array - JSON string in DB

    var $site_url;


    function __construct($params=array()) {
// common properties
        $this->id               = isset($params['id'])            ? $params['id'] : null;
        $this->username         = isset($params['username'])      ? $params['username']          : null;
        $this->name             = isset($params['name'])          ? $params['name']              : null;
        $this->severity         = isset($params['severity'])      ? $params['severity']          : null;
        $this->ruleid           = isset($params['ruleid'])        ? $params['ruleid']            : null;

        $this->widgetid         = isset($params['widgetid'])      ? $params['widgetid']          : null;
        $this->widgetName       = isset($params['widgetname'])    ? $params['widgetname']        : null;

// after first check
        $this->lastStatusChange = isset($params['laststatuschange']) ? (int)$params['laststatuschange'] : null;
        $this->lastCheck        = isset($params['lastcheck'])        ? (int)$params['lastcheck']        : null;
        $this->lastEventTime    = isset($params['lasteventtime'])    ? (int)$params['lasteventtime']    : null;   // this is when last event was created, we need this for reminder feature
        $this->status           = isset($params['status'])           ? $params['status']           : null;

// ALL alerts
        $this->failHosts        = isset($params['failhosts'])        ? $params['failhosts']        : 0;
        $this->totalHosts       = isset($params['totalhosts'])       ? $params['totalhosts']       : 0;

//if paused
        $this->pause  = isset($params['pause'])  ? (int)$params['pause']   : null;
        $this->paused = isset($params['paused']) ? $params['paused']  : 0;

        $this->serverTime = time();

        $this->emailToNotify = isset($params['emailtonotify'])  ? $params['emailtonotify']   : null;
        $this->reminder      = isset($params['reminder'])       ? (int)$params['reminder']        : null;

        $this->hostContextsProfileId = isset($params['hostcontextsprofileid']) ? $params['hostcontextsprofileid']  : null;
        $this->hostContextsPath      = isset($params['hostcontextspath'])      ? $params['hostcontextspath']       : null;
        $this->hostContexts          = isset($params['hostcontexts'])          ? json_decode($params['hostcontexts'],true) : null;
        $this->excludedHosts         = isset($params['excludedhosts'])          ? json_decode($params['excludedhosts'],true) : null;

        $this->site_url              = isset($params['site_url'])          ? $params['site_url']           : null;

    }

    function getId()
    {
        return $this->id;
    }

    function getUsername()
    {
        return $this->username;
    }

    function getName()
    {
        return $this->label;
    }

    function getSeverity()
    {
        return $this->severity;
    }

    function getRuleId()
    {
        return intval($this->ruleid);
    }

    function getWidgetId()
    {
        return $this->widgetid;
    }

    function getWidgetName()
    {
        return $this->widgetName;
    }


    function getLastStatusChange()
    {
        return $this->lastStatusChange;
    }

    function getLastCheck()
    {
        return $this->lastCheck;
    }

    function getFailHosts()
    {
        return $this->failHosts;
    }

    function getTotalHosts()
    {
        return $this->totalHosts;
    }

    function getPaused()
    {
        return $this->paused;
    }

    function getPause()
    {
        return $this->pause;
    }

    function getEmailToNotify()
    {
        return $this->emailToNotify;
    }

    function getReminder()
    {
        return $this->reminder;
    }

    function getServerTime() {
        return $this->serverTime;
    }


    function getHostContextsProfileId()
    {
        return $this->hostContextsProfileId;
    }

    function getHostContextsPath()
    {
        return $this->hostContextsPath;
    }


    function getHostContextsManual()
    {
        return $this->hostContextsManual;
    }

    function getSiteUrl()
    {
        return $this->site_url;
    }
}
?>
