<div class="settingsPage">

    <div class="left-column">
        <?php include('settingsSideBar.php'); ?>
    </div>

    <div class="right-column">

        <div class="pageTitle">
            <h1><span>User settings and preferences</span></h1>
        </div>

        <div>
            <div class="pullTop">

                <?php

                if (($this->session->flashdata('message')) || (isset($message) && is_array($message))) {
                    $flashMessage = $this->session->flashdata('message') ? $this->session->flashdata('message') : $message;
                    $content = $flashMessage['content'];
                    $content_class = $flashMessage['type'];
                    ?>
                    <div style="margin-top: 13px;">
                        <div class="alert <?php echo $content_class; ?>">
                            <button class="close" data-dismiss="alert"><i class="bi bi-x"></i></button>
                            <?php echo $content; ?>
                        </div>
                    </div>

                <?php } ?>
            </div>

            <?php
            // Change the css classes to suit your needs

            $attributes = array('class' => 'form-horizontal confirm-before-leave', 'id' => 'mpsettings', 'autocomplete' => "off");
            echo form_open_multipart('settings/preferences', $attributes);
            ?>


            <div class="control-group">
                <label class="control-label" for="appemail">Role based access control</label>
                <div class="controls">
                    <label for="mode" class="radio inline">
                        <?php
                        $elem = array(
                            'name' => 'rbac',
                            'id' => 'rbac_on',
                            'value' => 1,
                            'checked' => (isset($rbac) && $rbac ? TRUE : '')
                        );
                        echo form_radio($elem);
                        ?>
                        On
                    </label>

                    <label for="mode" class="radio inline">
                        <?php
                        $elem = array(
                            'name' => 'rbac',
                            'id' => 'rbac_off',
                            'value' => 0,
                            'checked' => (isset($rbac) && !$rbac ? TRUE : '')
                        );
                        echo form_radio($elem);
                        ?>
                        Off
                    </label>
                </div>
            </div>

            <div class="control-group">
                <label class="control-label" for="bluehost_threshold_global">Unreachable host threshold</label>
                <div class="controls">

                    <input id="bluehost_threshold_global" type="text" name="bluehost_threshold_global"
                           class="input-xlarge" maxlength="5" value="<?= htmlspecialchars($bluehost_threshold_global) ?>"/> <?php
                    if (!empty($bluehost_threshold_global)) {
                        echo "(" . time_diff_conv($bluehost_threshold_global * 60) . ")";
                    }
                    ?>
                    <p class="help-block"><?php echo tooltip('tooltip_bluehost_threshold'); ?></p>
                </div>
            </div>

            <div class="control-group">
                <label class="control-label" for="hostsCollisionsThreshold">Number of collisions (per hostkey) used to
                    identify a duplicate identity</label>
                <div class="controls">
                    <input id="hostsCollisionsThreshold" type="text" name="hostsCollisionsThreshold"
                           class="input-xlarge" maxlength="5" value="<?= htmlspecialchars($hostsCollisionsThreshold) ?>"/>
                </div>
            </div>


            <div class="control-group">
                <label class="control-label" for="API_log_level">Enterprise API log level</label>
                <div class="controls">
                    <?php
                    $options = array("emergency" => "Emergency",
                        "alert" => "Alert",
                        "critical" => "Critical",
                        "error" => "Error",
                        "warning" => "Warning",
                        "notice" => "Notice",
                        "info" => "Info",
                        "debug" => "Debug");
                    echo form_dropdown('api_log_level', $options, $logLevel);
                    ?>
                    <p class="help-block"><?php echo tooltip('tooltip_api_log_level'); ?></p>
                </div>
            </div>
            <hr />
            <h3>Security</h3>
            <div class="control-group">
                <label class="control-label" for="passwordComplexity">Password complexity</label>
                <div class="controls">
                    <?php
                    $options = [
                        "0" => "Disabled",
                        "1" => "Minimum",
                        "2" => "Decent",
                        "3" => "Strong",
                        "4" => "Strongest"
                    ];
                    echo form_dropdown('passwordComplexity', $options, $passwordComplexity);
                    ?>
                </div>
            </div>
            <div class="control-group">
                <label class="control-label" for="minPasswordLength">Min password length</label>
                <div class="controls">
                    <input id="minPasswordLength" type="number" name="minPasswordLength"
                           class="large" min="8" max="20" value="<?= htmlspecialchars($minPasswordLength) ?>"/>
                </div>
            </div>
            <div class="control-group">
                <label class="control-label" for="passwordExpirationAfterResetHours">Password expiration after reset (hours)</label>
                <div class="controls">
                    <input id="passwordExpirationAfterResetHours" type="number" name="passwordExpirationAfterResetHours"
                           class="large" min="0" value="<?= htmlspecialchars($passwordExpirationAfterResetHours) ?>"/>

                    <label for="mode" class="radio inline">
                        Never expire &nbsp;
                        <?php
                        $elem = array(
                            'name' => 'never_expire',
                            'value' => '1',
                            'id' => 'never_expire',
                            'checked' => (isset($passwordExpirationAfterResetHours) && $passwordExpirationAfterResetHours === 0)
                        );
                        echo form_checkbox($elem);
                        ?>
                    </label>
                </div>
            </div>

            <div>
                <div class="control-group">
                    <label class="control-label" for="enforce2FA">Enforce 2FA for all users</label>
                    <div class="controls">
                        <input id="enforce2FA" type="checkbox" name="enforce2FA" value="1" <?= $enforce2FA ? 'checked' : '' ?> />
                    </div>
                </div>
                <p class="help-block" style="margin-left: 27px; margin-top: -10px">
                    All users have to enable 2FA within 48 hours after the first login.
                    Otherwise, their accounts will be locked.
                </p>
            </div>
            
            <div class="buttons">
                <?php echo form_submit(array('name' => 'submit', 'class' => 'btn btn-primary btn-large pull-right', 'value' => 'Apply')); ?>
            </div>

            <?php echo form_close(); ?>

        </div>
    </div>
</div>
<script type="text/javascript">
    $(document).ready(function () {

        $('input[type=file]').bootstrapFileInput();
        $('.file-input-wrapper').addClass('btn-large');


        $('#ldapsettings').hide();
        var mode = $("input[name='mode']:checked").val();
        var elem = $("select[name='admin_role']").clone();
        var grplbl = $('#selected_grplbl').clone();
        //var getgrpbtn=$('#getgrpsbtn').clone();
        var grpcontainer = $('#admingrpsec');
        settings_toggle();

        function settings_toggle() {
            if ($("input[name='mode']:checked").val() == 'internal') {
                $('#ldapsettings').hide();

            } else if ($("input[name='mode']:checked").val() == 'ldap') {
                $('#ldapsettings').show();
                $('.adrelated').hide();
                //$('.member_attribute_related').show();
                $('.ldaprelated').show();
                $("#addmore").show();
                //$('#getgrpsbtn').show()

            } else if ($("input[name='mode']:checked").val() == 'activeDirectory') {
                $('#ldapsettings').show()
                $('.adrelated').show();
                $('.member_attribute_related').hide();
                $('.ldaprelated').hide();
                $("#addmore").hide();
                //$('#getgrpsbtn').show()
            }
        };

        $(".rmbtns").on('click', function (event) {
            var addmorebtn = $('#addmore');
            if ($(this).parent().prev().find('#effective_dir').length > 0) {
                $('#effective_dir').before(addmorebtn);
            } else {
                $(this).parent().prev().append(addmorebtn);
            }
            $(this).parent().remove();
        });

        $("input[name='mode']").change(function () {
            settings_toggle();

        });

        /**
         * Handle never expire checkbox change
         */
        const expirationInput = document.getElementById('passwordExpirationAfterResetHours');
        const neverExpireCheck = document.getElementById('never_expire');
        let expirationInputInitialValue = parseInt(expirationInput.value);

        neverExpireCheck.addEventListener('change', e => {
            expirationInput.value = e.target.checked ? 0 : (expirationInputInitialValue || 48);
        });

        expirationInput.addEventListener('input', () => {
            neverExpireCheck.checked = expirationInput.value === '0';
        });
    });
</script>
