<?php

class UsersListRequestStructure
{
    public const EXTERNAL_USER_TYPE = 'external';
    public const INTERNAL_USER_TYPE = 'internal';

    /**
     * @var string
     */
    private $userName;
    /**
     * @var string
     */
    private $userNameRx;
    /**
     * @var string
     */
    private $userType;
    /**
     * @var int
     */
    private $page;

    /**
     * @var int
     */
    private $count;

    /**
     * @var bool
     */
    private ?bool $isTwoFaEnforced;

    /**
     * @var bool
     */
    private ?bool $determineInactiveUsers;

    /**
     * UsersListRequestStructure constructor.
     * @param bool $userName
     * @param bool $usernameRx
     * @param bool $userType
     * @param bool $page
     * @param bool $count
     * @param bool $determineInactiveUsers
     */
    public function __construct($userName = false, $usernameRx = false, $userType = false, $page = false, $count = false, $isTwoFaEnforced = false, string|bool $determineInactiveUsers = false)
    {
        $this->userName = $userName;
        $this->userNameRx = $usernameRx;
        $this->userType = $userType;
        $this->page = $page ? $page : DefaultParameters::page();
        $this->count = $count ? $count : DefaultParameters::count();
        $this->isTwoFaEnforced = $isTwoFaEnforced;
        $this->setDetermineInactiveUsers($determineInactiveUsers);
    }

    /**
     * @return mixed
     */
    public function getUserName()
    {
        return $this->userName;
    }

    /**
     * @param mixed $userName
     */
    public function setUserName($userName)
    {
        $this->userName = $userName;
    }

    /**
     * @return mixed
     */
    public function getUserNameRx()
    {
        return $this->userNameRx;
    }

    /**
     * @param mixed $userNameRx
     */
    public function setUserNameRx($userNameRx)
    {
        $this->userNameRx = $userNameRx;
    }


    /**
     * @return mixed
     */
    public function getPage()
    {
        return $this->page;
    }

    /**
     * @param mixed $page
     */
    public function setPage($page)
    {
        $this->page = $page;
    }

    /**
     * @return mixed
     */
    public function getCount()
    {
        return $this->count;
    }

    /**
     * @param mixed $count
     */
    public function setCount($count)
    {
        $this->count = $count;
    }



    /**
     * @return bool
     */
    public function getUserType()
    {
        return $this->userType;
    }

    public function isTwoFaEnforced(): ?bool
    {
        return $this->isTwoFaEnforced;
    }

    public function setIsTwoFaEnforced(bool $isTwoFaEnforced): void
    {
        $this->isTwoFaEnforced = $isTwoFaEnforced;
    }

    public function isDetermineInactiveUsers(): ?bool
    {
        return $this->determineInactiveUsers;
    }

    public function setDetermineInactiveUsers(string|bool $determineInactiveUsers): void
    {
        if (is_string($determineInactiveUsers)) {
            $determineInactiveUsers = $determineInactiveUsers === 'true';
        }
        $this->determineInactiveUsers = $determineInactiveUsers;
    }

    /**
     * @param bool $userType
     */
    public function setUserType($userType)
    {
        $this->userType = $userType;
    }

    /**
     *
     */
    public function validate()
    {
        if ($this->count < 0) {
            throw new InvalidArgumentException('UsersListRequestStructure::count cannot be less than zero.');
        }

        if ($this->page < 0) {
            throw new InvalidArgumentException('UsersListRequestStructure::page cannot be less than zero.');
        }

        if ($this->userName == false) {
            throw new InvalidArgumentException('UsersListRequestStructure::userName cannot be blank.');
        }

        if ($this->userType == false || !in_array($this->userType, [self::EXTERNAL_USER_TYPE, self::INTERNAL_USER_TYPE])) {
            throw new InvalidArgumentException('UsersListRequestStructure::userType must be `external` or `internal`.');
        }

        return true;
    }


}
