import React from 'react';
import { createRoot } from 'react-dom/client';
import { Provider } from 'react-redux';
import createCache from '@emotion/cache';
import { CacheProvider } from '@emotion/react';
import { store } from '../components/LlmSettings/store';
import LlmSettings from '../components/LlmSettings/LlmSettings';
import { ThemeListener } from '../components/ThemeListener/ThemeListener';

const root = createRoot(document.getElementById('llm-settings-root') as HTMLElement);
const cache = createCache({ key: 'mui', prepend: true });
root.render(
  <React.StrictMode>
    <Provider store={store}>
      <CacheProvider value={cache}>
        <ThemeListener>
          <LlmSettings />
        </ThemeListener>
      </CacheProvider>
    </Provider>
  </React.StrictMode>
);
