<?php

class AuditLogListArgumentsValidator
{
    public static function validate(array $input): array
    {
        if (isset($input['sort_column']) && !in_array($input['sort_column'], AuditLogModel::ALLOWED_SORT_COLUMNS)) {
            throw new \InvalidArgumentException("Sort column `{$input['sort_column']}` is not allowed");
        }

        if (isset($input['object_type']) && !in_array($input['object_type'], AuditLogObjectTypes::ALLOWED_TYPES)) {
            throw new \InvalidArgumentException("Object type `{$input['object_type']}` is not allowed");
        }

        if (isset($input['action']) && !in_array($input['action'], AuditLogActions::ALLOWED_ACTIONS)) {
            throw new \InvalidArgumentException("Action `{$input['action']}` is not allowed");
        }

        if (isset($input['limit'])) {
            Validator::greaterThanOrEqual($input['limit'], 1, 'Limit');
        }

        if (isset($input['offset'])) {
            Validator::greaterThanOrEqual($input['offset'], 0, 'Offset');
        }

        if (isset($input['created_after'])) {
            Validator::greaterThanOrEqual($input['created_after'], 1, 'Created after');
        }

        if (isset($input['created_before'])) {
            Validator::greaterThanOrEqual($input['created_before'], 1, 'Created before');
        }

        return $input;
    }
}
