dashboardApp.directive('decommissionedHostWidget', ['decommissionedHostsWidgetHelper', '$q', function (decommissionedHostsWidgetHelper) {
    return {
        templateUrl: MP_SITE_URL + '/dashboard/partials/host_count_widget',
        restrict: 'A',
        scope: {
            widget: '=',
            currentUser: "=",
            currentDash: "=",
            saveOldName: '&',
            editName: '&',
            deleteWidget: '&',

        },
        link: function (scope, element) {
            scope.fromToData = {};
            scope.selectedGroup = 'Day';
            scope.dateRange = decommissionedHostsWidgetHelper.initDateRange();
            scope.groups = [
                'Day',
                'Week',
                'Month',
                'Year'
            ];

            scope.refresh = function () {
                return element.attr('refresh');
            }
            scope.$watch(scope.refresh,function () {
                scope.chartList = decommissionedHostsWidgetHelper.getChartConfig();
            })
            scope.$watch('dateRange', function () {
                scope.fromToData = {from: scope.dateRange.startDate, to: scope.dateRange.endDate};
            });

            scope.$watchCollection('[fromToData, selectedGroup, refresh]', function (newValues) {
                decommissionedHostsWidgetHelper.getDecommissionedHostsStats(newValues[0], newValues[1]).then(
                    function (result) {
                        decommissionedHostsWidgetHelper.setChartData(result.data.data);
                        scope.widget.changeStats = result.data.data;
                        scope.chartList = decommissionedHostsWidgetHelper.chartConfig;
                    }
                );
            });
        }
    };

}]);
