import React from 'react';
import { createRoot } from 'react-dom/client';
import { Provider } from 'react-redux';
import { BrowserRouter, Route, Routes } from 'react-router-dom';

import createCache from '@emotion/cache';
import { CacheProvider } from '@emotion/react';
import { LocalizationProvider } from '@mui/x-date-pickers';
import { AdapterDayjs } from '@mui/x-date-pickers/AdapterDayjs';

import { store } from '@northern.tech/store/store';

import AuditLogEvent from '../components/Auditlog/AuditLogEvent';
import Auditlog from '../components/Auditlog/Auditlog';
import '../components/Auditlog/auditlogs.scss';
import { AUDIT_LOG_BASE } from '../components/Auditlog/store/constants';
import { ThemeListener } from '../components/ThemeListener/ThemeListener';
import '../styles.scss';

const root = createRoot(document.getElementById('auditlogs-root') as HTMLElement);
const cache = createCache({ key: 'mui', prepend: true });
root.render(
  <React.StrictMode>
    <Provider store={store}>
      <CacheProvider value={cache}>
        <LocalizationProvider dateAdapter={AdapterDayjs}>
          <BrowserRouter basename={AUDIT_LOG_BASE}>
            <ThemeListener>
              <Routes>
                <Route path="/" element={<Auditlog />} />
                <Route path="/:id" element={<AuditLogEvent />} />
              </Routes>
            </ThemeListener>
          </BrowserRouter>
        </LocalizationProvider>
      </CacheProvider>
    </Provider>
  </React.StrictMode>
);
