<?php


class Cf_Encrypt extends CI_Encryption
{

    /**
     * Cf_Encrypt constructor.
     * @override
     */
    public function __construct(array $params = array())
    {
        parent::__construct($params);
        $this->_modes['openssl']['cbc'] = 'CBC';
        log_message('info', 'Cf_Encrypt Class Initialized');
    }

    public function encryptByKey($data, $key)
    {
        $key = $this->modifyEncryptionKey($key);
        return parent::encrypt($data, [
            'cipher' => 'AES-128',
            'mode' => 'cbc',
            'key' => $key,
            'hmac_digest' => 'sha512',
            'hmac_key' => $key
        ]);
    }

    public function decryptByKey($data, $key)
    {
        $key = $this->modifyEncryptionKey($key);
        return parent::decrypt($data, [
            'cipher' => 'AES-128',
            'mode' => 'cbc',
            'key' => $key,
            'hmac_digest' => 'sha512',
            'hmac_key' => $key
        ]);
    }

    private function modifyEncryptionKey($key)
    {
        return base64_encode(strrev($key) . strlen($key));
    }

}
