<?php

/**
 * Class hub_management
 */
class Hub_management extends Cf_Controller
{

    public function __construct()
    {
        parent::__construct();
        setCurrentApplication('hub_management');
        $this->load->helper('url');
    }

    function index()
    {
        if (str_ends_with(uri_string(),'hub_management')){
            redirect('hub-management', 'refresh');
        }
        $requiredcss = array(
            array('../../../themes/default/css/angularjs-ui/angular-ui.css')
        );

        $this->carabiner->css($requiredcss);

        $requiredAngularjs = array(
            array('dist/angular-base.bundle.js'),
        );

        $requiredjs = array(
            array('hubManagement/app.js'),
            array('hubManagement/controllers/hubManagementController.js'),
            array('hubManagement/services/hubManagementService.js'),
            array('hubManagement/directives/sshKeyLoader.js'),

            // action service to trigger an agent run after enabling the Policy analyzer
            array('common_directives/actions/actionService.js'),
            array('common_directives/actions/actionHelper.js'),
        );

        $this->carabiner->js($requiredAngularjs, $requiredAngularjs, $combine = true, $minify = false);
        $this->carabiner->js($requiredjs, $requiredjs, $combine = true, $minify = true);

        $data = array('title' => 'Mission Portal - Hub management');

        $this->template->load('template', 'hub_management/index', $data);
    }

}
