var naviTreeService = Class.extend({
    LOAD_NAVITREE_PROFILE_URL: MP_SITE_URL + '/astrolabe/profile/',
    SEARCH_HOSTS_URL: MP_SITE_URL + '/host/searchHost?query=',

    LOAD_NAVITREE_ASTRO_HOSTS:        MP_SITE_URL + '/astrolabe/host/',

    /**
     * @return Service handler
     */
    getTreeProfiles: function() {
        return this.$http.get(this.LOAD_NAVITREE_PROFILE_URL, {
            cache: false
        });
    },
    getTreeNodes: function(tree) {
        var url = this.LOAD_NAVITREE_PROFILE_URL + encodeURIComponent(tree.id) + '/' + tree.shared + '/' + tree.sharedFrom;
        return this.$http.get(url, {
            cache: false
        });

    },

    searchHosts: function(query) {
        var url = this.SEARCH_HOSTS_URL + encodeURIComponent(query);
        return this.$http.get(url, {
            cache: false
        });

    },

     getNodeHosts: function(includesArray) {
        var url = this.LOAD_NAVITREE_ASTRO_HOSTS;

         return this.$http({
             url: url,
             method: 'POST',
             headers: {
                 'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'
             },
             data: $.param({'includes': includesArray}),
             transformRequest: angular.identity
         });
    }
});



(function() {

    var naviTreeServiceProvider = Class.extend({
        instance: new naviTreeService(),
        $get: ['$http', function($http) {
            this.instance.$http = $http;
            return this.instance;
        }]
    });

    angular.module('dc.naviTreeService', [])
        .provider('naviTreeService', naviTreeServiceProvider);
}());