(function($) {
    $.widget('ui.astrolabeLocation', {
        options: {
            defaultbehaviour: true,
            defaultLabel: 'Selected: ',
            defaultHostLabel: 'Selected host: ',
            defaultContextPathLabel: 'Selected context: ',
            defaultHeaderWrapper:'<span>',
            defaultLabelWrapper:'<small>',
            defaultValue: '',
            hostBaseUrl: ''
        },

        _create: function() {
            var $self = this;

            $self.element.addClass('astrolabeLocation');
            $self._headerWrapper=$($self.options.defaultHeaderWrapper);


            $self._label = $($self.options.defaultLabelWrapper);
            $self._label.html($self.options.defaultLabel);
            $self._headerWrapper.append($self._label);
            $self._value = $('<span>');
            $self._value.html($self.options.defaultValue);
            $self._headerWrapper.append($self._value);

            // at first, hide the help icon, in case the host is not found in which case we don't want to show it.
            var icon = '<span class="pull-right"><i style="display:none" rel="tooltip" id="tab-context-help-icon" class="CFE-context-help help bi bi-question-circle-fill" data-key="vitals-tab" data-title="Measurements" data data-placement="left" title="Click for help"></i></span>';

            $self._headerWrapper.prepend(icon);
            $self.element.append($self._headerWrapper);
        },

        setContextPath: function(path, count) {
            var $self = this;

            $self._label.html($self.options.defaultContextPathLabel);

            var pathString = '';
            var firstPath = true;
            for (var i in path) {
                if (!firstPath)
                    pathString = pathString + ' &raquo; ';
                pathString = pathString + path[i];
                firstPath = false;
            }

            if (count !== 0 && count !== undefined) {
                pathString = pathString + ' (' + count + ')';
            }

            $self._value.html(pathString);
        },

        setHostName: function(hostname) {
            var $self = this;
            $self._label.html($self.options.defaultHostLabel);
            $self._value.text(hostname);
        },

        destroy: function() {
            $.Widget.prototype.destroy.call(this);
        }

    });

    $.extend($.ui.astrolabeLocation, {
        instances: []
    });
})(jQuery);
