<div class="pageTitle">
    <h1>
        <span>Schedule report</span>
    </h1>
</div>

<div class="" id="filterTree" ng-init="showFilter=false" ng-class="{'open':showFilter}">
    <div class="accordion-group">
        <div class="accordion-toggle accordion-heading" data-parent="#filterTree" data-toggle="collapse">
            <span ng-click="showFilter=!showFilter">
                <i class="icon-chevron-right" ng-show="!showFilter" style="padding: 0px 5px;"></i>
                <i class="icon-chevron-down" ng-show="showFilter" style="padding: 0px 5px;"></i>
                Filters</span>
        </div>
    </div>

    <div class="margin-left-small">
        <?php $this->load->view('/partials/_environmentFilter'); ?>

    </div>
</div>
<div style="margin-top:80px ">
    <h3 ng-show="reportLabel.input" class="padding-bottom">
        {{reportLabel.input}}
    </h3>
    <?php
      $this->load->view('/partials/_notification');
    ?>
    <div ng-show="!isObjEmpty(schedules)" class="padding-bottom">
        <h4 class="margin-bottom">
            Schedules
        </h4>
       <table class="table table-horizontal max-table">
           <tr>
               <th>Name</th>
               <th>Time (GMT)</th>
               <th>Local time</th>
               <th>Host filter</th>
               <th>Author</th>
               <th colspan="3"></th>
           </tr>
           <tr ng-repeat="(rowid, row) in schedules">
               <td>{{row.scheduleName}}</td>
               <td>{{row.scheduleHumanReadableTime}}</td>
               <td>{{convertGMTHumanReadableToLocalTime(row.scheduleHumanReadableTime)}}</td>

               <td><span ng-show='row.hostcontexts.includes' title="{{row.hostcontexts | showEnvironmentFilter}}">{{row.hostcontexts  | showEnvironmentFilter | truncateString: false:30:'...'}}</span></td>
               <td>{{row.userId}}</td>
               <td>
                   <?php // if user can view report - this mean that he is not an owner, so not allow editing ?>
                   <a ng-show="row.can_edit==1 && row.can_view!=1" ng-click="editSchedule(row.id)" href="javascript:void(0)">Edit</a>
               </td>
               <td>
                    <a ng-show="row.can_view==1" ng-click="viewSchedule(row.id)" href="javascript:void(0)">View</a>
               </td>
               <td><a ng-show="row.can_delete==1" class="delete" ng-click="deleteSchedule(row.id)" href="javascript:void(0)">Delete</a></td>
           </tr>
       </table>
    </div>
    <div class="overflow-hidden" ng-show="(reportLabel.input == '' || reportLabel.input === undefined)|| reportId==='' ">
        <fieldset class="form-horizontal scheduler margin-bottom">
            <h3>Report data</h3>

            <?php
                $data['formName'] = 'scheduleForm';
                $this->load->view('/partials/elements/_saveSearchRolesPublicCheckboxes', $data);
            ?>
        </fieldset>
    </div>

    <div class="border-top">
    <h3>Schedule a report</h3>
        <form class="form form-horizontal scheduleForm overflow-hidden confirm-before-leave" name="scheduleForm">
            <fieldset class="scheduler">
                <div class="control-group required">
                    <label for="scheduleName" class="control-label">
                        Schedule name
                    </label>
                    <div class="controls">
                        <input type="text" ng-model="schedule.scheduleName" ng-required="true"  id="scheduleName" name="scheduleName" ng-pattern="/^[A-Za-z0-9-_%,.<>()=\s]+$/" maxlength="100" />
                        <div class="error" ng-show="scheduleForm.scheduleName.$dirty && scheduleForm.scheduleName.$invalid">
                            <span ng-show="scheduleForm.scheduleName.$error.required">Schedule name is required.</span>
                            <span ng-show="scheduleForm.scheduleName.$error.pattern">Please use only letters, numbers, space and -%,._&lt;&rt;>()=.</span>
                        </div>
                    </div>
                </div>
                <div class="control-group required">
                    <label for="emailFrom" class="control-label">
                        From
                    </label>
                    <div class="controls">
                        <input type="email" ng-init="scheduleForm.emailFrom.isFocused=false" ng-focus="scheduleForm.emailFrom.isFocused=true" ng-blur="scheduleForm.emailFrom.isFocused=false" ng-model="schedule.emailFrom" ng-required="true" id="emailFrom" name="emailFrom" maxlength="100" />
                        <div class="error" ng-show="scheduleForm.emailFrom.$dirty && scheduleForm.emailFrom.$invalid">
                            <span ng-show="scheduleForm.emailFrom.$error.required">Sender email is required.</span>
                            <span ng-show="scheduleForm.emailFrom.$error.email&&!scheduleForm.emailFrom.isFocused">This is not a valid email address.</span>
                        </div>
                    </div>
                </div>
                <div class="control-group">
                    <label class="control-label" for="emailTo">To</label>
                    <div class="controls">
                        <input type="email" ng-init="scheduleForm.emailTo.isFocused=false" ng-focus="scheduleForm.emailTo.isFocused=true" ng-blur="scheduleForm.emailTo.isFocused=false" ng-model="schedule.emailTo" value="" id="emailTo" name="emailTo" maxlength="100">
                        <div class="help-block">If left blank report will only be saved to:<br />{{realPath}}<?php //  echo realpath($this->config->item('scheduled_reports_save_path')); ?></div>
                        <div class="error" ng-show="scheduleForm.emailTo.$dirty && scheduleForm.emailTo.$invalid">
                            <span ng-show="scheduleForm.emailTo.$error.email&&!scheduleForm.emailTo.isFocused">This is not a valid email address.</span>
                        </div>
                    </div>
                </div>

                <div class="control-group skipMailing">

                    <div class="controls">
                        <label class="checkbox">
                            <input ng-model="schedule.skipMailing" name="skipMailing"  id="skipMailing" value="1" type="checkbox">
                            Don't send if report is empty.
                        </label>
                    </div>
                </div>

                <div class="control-group required">
                    <label for="schedulePDF" class="control-label">
                        Report type
                    </label>

                    <div class="controls">
                        <label class="checkbox">
                            <input ng-model="schedule.schedulePDF" name="schedulePDF" type="checkbox">
                            PDF
                        </label>
                        <label class="checkbox">
                            <input ng-model="schedule.scheduleCSV"  name="scheduleCSV" type="checkbox">
                            CSV
                        </label>

                        <div class="error" ng-show="validation.showreportTypeWarning==true">
                            <span>The report type is required.</span>
                        </div>
                    </div>
                </div>



                <div class="control-group datepick">
                    <label class="control-label" for="scheduledTime">Schedule day</label>
                    <div class="controls">
                        <select ng-model="schedule.reportTimeType" name="reportTimeType" ng-options="c for c in scheduleLists.reportTimeTypesList" class=""></select>
                    </div>
                    <div class="controls" ng-show="schedule.reportTimeType=='monthly'">
                        <select ng-model="schedule.dayNumber" name="dayNumber" ng-options="f.value as f.label for f in scheduleLists.dayNumbersList" class=""></select>
                    </div>

                    <div class="controls" ng-show="schedule.reportTimeType=='weekly'">
                        <select ng-model="schedule.dayName" name="dayName" ng-options="c for c in scheduleLists.dayNameList" class=""></select>
                    </div>
                     <div class="controls" ng-show="schedule.reportTimeType=='once'">
                         <input type="text" ng-model="schedule.singleDay" value="{{schedule.singleDay}}" name="singleDay" class="bind-datetimepicker" timeFormat="" />
                    </div>
                </div>

                <div class="control-group timepick">
                    <label class="control-label" for="timeH">
                        <div>Time (GMT)</div>
                        <div>no time offset added</div>
                    </label>
                    <div class="controls">
                        <select ng-model="schedule.hour" name="hour" ng-options="f.value as f.label for f in scheduleLists.hoursList" class="pull-left"></select>
                        <select ng-model="schedule.minute" name="minute" ng-options="f.value as f.label for f in scheduleLists.minutesList" class="pull-left"></select>
                        <div class="alert margin-bottom-small padding_5 alert-warning inline-block margin-top-small" >
                            Report will be sent at <br /> <b>{{localTime}}</b> local time
                        </div>
                    </div>
                </div>
                <div class="control-group">
                    <label for="saveContext" class="control-label">

                    </label>

                    <div class="controls">
                        <label class="checkbox">
                            <input ng-model="saveContext" name="saveContext" type="checkbox">
                            Apply host filter
                        </label>
                        <div class="help-block">Schedule the report on the current active host filter only<span ng-show="loadedSchedule"> (overwrite current context)</span>.</div>
                    </div>
                </div>
                 <div class="control-group" ng-show="loadedSchedule">
                    <label ng-show="savedHostcontexts.name.length || savedHostcontexts.includes.length" for="currentContext" class="control-label">
                        Current context
                    </label>

                    <div class="controls level-text" name="currentContext">
                      <span ng-show="savedHostcontexts.name.length || savedHostcontexts.includes.length">Activated on: <span style="color: green">{{savedHostcontexts | showEnvironmentFilter | truncateString: false:70:'...'}}</span></span><br />
                    </div>

                     <div class="controls level-text" name="currentContext">
                         <span ng-show="savedExcludedhosts.name.length>0">Excluded: <span style="color: green">{{savedExcludedhosts.name | truncateString: false:70:'...'}}</span></span><br />
                     </div>
                </div>
            </fieldset>


            <fieldset class="scheduler">
                <div class="control-group">
                    <label class="control-label">Report title</label>
                    <div class="controls">
                        <input class="input" ng-model="schedule.outputReportTitle" type="text" value="{{schedule.outputReportTitle}}" id="report_title" name="report_title"  maxlength="100"/>
                    </div>
                </div>
                <div class="control-group">
                    <label class="control-label">Report description</label>
                    <div class="controls">
                        <textarea placeholder="optional" id="report_description" ng-model="schedule.outputReportDescription" name="outputReportDescription"  rows="3" cols="10" maxlength="300"></textarea>
                    </div>
                </div>
            </fieldset>
        </form>
    </div>
</div>

<div class="buttons">
    <div class="pull-right">
        <button class="btn btn-large" ng-click="cancelSchedule()">Cancel</button>
        <button ng-show="save_allowed==1" class="btn btn-large btn-primary" ng-click="saveSchedule()" ng-disabled="validateForm()">Save</button>
        <button ng-show="save_allowed==1 && showOverwrite == true" class="btn btn-large btn-danger"   ng-click="saveSchedule(true)" ng-disabled="validateForm()">Overwrite</button>
    </div>
</div>
