'use client';

import { Message } from '../store/chatSlice';

const STORAGE_KEYS = {
  AI_AGENT_MESSAGES: 'aiAgent_messages',
  AI_AGENT_MINIMIZED: 'aiAgent_minimized'
} as const;

export const getStoredMessages = (): Message[] => {
  const stored = localStorage.getItem(STORAGE_KEYS.AI_AGENT_MESSAGES);
  return stored ? JSON.parse(stored) : [];
};

export const saveMessagesToStorage = (messages: Message[]): void => {
  localStorage.setItem(STORAGE_KEYS.AI_AGENT_MESSAGES, JSON.stringify(messages));
};

export const getStoredMinimizedState = (): boolean => {
  const stored = localStorage.getItem(STORAGE_KEYS.AI_AGENT_MINIMIZED);
  return stored ? JSON.parse(stored) : false;
};

export const saveMinimizedState = (minimized: boolean): void => {
  localStorage.setItem(STORAGE_KEYS.AI_AGENT_MINIMIZED, JSON.stringify(minimized));
};
