import { CmdbItem } from '../store/cmdbSlice/thunks'

export const renderValue = (value) => {
    if (value === null || typeof value === 'string') {
        return value;
    }

    if (Array.isArray(value) || typeof value === 'object') {
        return JSON.stringify(value, null, 2);
    }

    return value;
};

export const getFirstEntryValue = (item?: CmdbItem): any => item?.entries?.[0]?.item_value;
export const getFirstEntryName = (item?: CmdbItem): string => item?.entries?.[0]?.item_name || '';
export const getFirstEntryId = (item?: CmdbItem): number | undefined => item?.entries?.[0]?.id;
export const getFirstEntryHostkey = (item?: CmdbItem): string => item?.entries?.[0]?.hostkey || '';
export const getPolicyId = (item?: CmdbItem): string => item?.meta?.policyId  || '';

export const aceTheme = isDarkMode => isDarkMode ? "tomorrow_night" : "github";

export const isEditAllowed = (permissions : []) => permissions.includes('cmdb.update');
export const isCreateAllowed = (permissions : []) => permissions.includes('cmdb.create');
export const isDeleteAllowed = (permissions : []) => permissions.includes('cmdb.delete');
