'use strict';

var sshKeyServiceClass = Class.extend({
  URL: MP_SITE_URL + '/sshKey/key',

  generate: function () {
    return this.$http.post(this.URL, { cache: false });
  },

  delete: function (id) {
    return this.$http.delete(`${this.URL}/${id}`, { cache: false });
  },

  get: function (id) {
    return this.$http.get(`${this.URL}/${id}`, { cache: false });
  }
});

(function () {
  const sshKeyServiceClassProvider = Class.extend({
    instance: new sshKeyServiceClass(),
    $get: [
      '$http',
      function ($http) {
        this.instance.$http = $http;
        return this.instance;
      }
    ]
  });

  angular.module('sshKeyServiceModule', []).provider('sshKeyService', sshKeyServiceClassProvider);
})();
