'use strict';
/**
 * Show notification window to user if session expired.
 *
 * intervalSeconds      = period in SECONDS to check cookie. We will try to do this 10 times, interval is taked from PHP session expired timeout
 *
 * intervalMilliseconds = intervalSeconds in milliseconds
 *
 * secondsPassed        = because timer will start first time after intervalSeconds seconds, we should start from this value
 *
 * openPageTime         = store timestamp from last request to MP
 *
 */
$(document).ready(function() {
        let data = $.cookie("CFE_MP_DATA") == undefined ? null : $.cookie("CFE_MP_DATA");
        var cookieData =  $.parseJSON(data);

        // if we are not able to set/get cookie - do nothing
        if (cookieData == null)
        {
            return;
        }

        var intervalSeconds      = Math.floor(cookieData.SessionExpiredTimeout / 10);
        var intervalMilliseconds = intervalSeconds * 1000;
        var secondsPassed        = intervalSeconds;
        var openPageTime         = cookieData.LastMPRequest;

        if (SessionCheckTimer !== undefined) {
           clearInterval(SessionCheckTimer);
        }

        var SessionCheckTimer = setInterval(function() {
                var currentCookie = $.parseJSON($.cookie("CFE_MP_DATA"));
                secondsPassed += intervalSeconds;

                if(openPageTime != currentCookie.LastMPRequest)
                { // if new request was made - reset seconds passed
                    secondsPassed = intervalSeconds;
                    openPageTime  = currentCookie.LastMPRequest;
                }
                else if ((currentCookie.LastMPRequest + currentCookie.SessionExpiredTimeout) <= (currentCookie.LastMPRequest + secondsPassed))
                {
                   clearInterval(SessionCheckTimer);

                   var logoutUrl = MP_SITE_URL + '/login/logout';

                   var $modal = $('<div id="SessionExpiredModal" class="modal hide fade" tabindex="-1" role="dialog" aria-hidden="true">' +
                                '<div class="modal-header">' +
                                     '<button type="button" class="close" data-dismiss="modal" aria-hidden="true" onclick="window.location=\''+ logoutUrl +'\'"><i class="bi bi-x"></i></button>' +
                                     '<h2>Session expired</h2>' +
                                 '</div>' +
                                 '<div class="modal-body">' +
                                     '<p>Your session has expired. Please login again.</p>' +
                                 '</div>' +
                                 '<div class="modal-footer">' +
                                     '<button class="btn btn-primary btn-large" data-dismiss="modal" onclick="window.location=\'' + logoutUrl + '\'">Ok</button>' +
                                 '</div>' +
                            '</div>');

                   $modal.modal('show');
                }
            }, intervalMilliseconds);
});