/*jslint node: true */
/*jslint browser: true*/
/*jslint nomen: true*/
/*jslint plusplus: true */
/*global dashboardApp, angular, $*/

'use strict';

dashboardApp.factory('tourGuideHelper',
    ['$rootScope','$q', '$http',
        function ($rootScope, $q, $http) {
            var helper = {};
            var tourSeenUrl = '/tourGuide/seenTour';

            helper.getTourSeen = function () {
                return $http({
                    method: 'get',
                    url: tourSeenUrl,
                    cache: false
                });
            };

            helper.changeSeenTour = function (value) {
                $http({
                    method: 'post',
                    url: tourSeenUrl,
                    headers : {
                        'Content-Type':'application/x-www-form-urlencoded; charset=UTF-8'
                    },
                    data: {seenTour: value},
                    cache: false
                }).then(function (data) {
                    return data;
                });
            };

            return helper;
        }]);