<div ng-if="user">
    <div class="flex flex--align_center">
        <h3>Two-factor authentication</h3>
        <div class="checkbox-switch blue inline-block margin-left">
            <input id="enableCheck" ng-model="data.twoFaCheckEnabled" type="checkbox"
                   class="ng-pristine ng-untouched ng-valid ng-empty">
            <label for="enableCheck" ng-click="data.twoFaCheckEnabled ? disable($event) : enable()" class="label-orange"></label>
        </div>
    </div>
    <div ng-if="user.two_factor_enabled">
        <span class="text-transform_none badge badge-success-inverse badge-xl no-margin">Configured</span>
    </div>
    <div ng-if="!user.two_factor_enabled">
        <div ng-if="configureInProcess">
            <h4>Setup:</h4>
            <div>
                <div class="flex flex--align_center">
                <div id="canvas"></div>
                <ol>
                    <li>
                        To use Two-Factor Authentication, first download a third party authentication app such as
                        <a href="https://support.google.com/accounts/answer/1066447" target="_blank"
                           rel="noopener noreferrer">Google Authenticator</a>
                        or
                        <a href="https://authy.com/download/" target="_blank" rel="noopener noreferrer">Authy</a>
                        .
                    </li>
                    <li class="margin-top-small">
                        Scan the QR code on the left with the authenticator app you just downloaded 
                        on your device or enter this code <code>{{ twoFaSecret }}</code> instead.
                    </li>
                    <li class="margin-top-small">
                        <div>
                            <div>Type the generated code in the input field below and click Verify.</div>
                            <div  class="flex flex--align_baseline margin-top-small">
                                <input placeholder="xxxxxx" autocomplete="off" style="max-width: 120px" class="margin-right-small" enter-press="verify()" ng-model="data.code" maxlength="6" />
                                <button class="btn btn-small btn-primary" ng-click="verify()">Verify</button>
                            </div>
                        </div>
                    </li>
                    
                </ol>
                </div>
                <div>Each time you log in, you will be asked for a verification code which you can retrieve from
                    the authentication app on your device.
                </div>
                <div>
                </div>
            </div>
        </div>
    </div>
</div>
<div ng-if="!user">
    <span class="loadinggif"></span>
</div>